/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.WasFileServing;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UpdateWasFileServingEnabledStep
extends WasStepBase {
    protected NamedDeployableArtifact application;
    private String warName;
    private WasTarget target;
    private WasFileServing fileServingEnabled;

    public UpdateWasFileServingEnabledStep(NamedDeployableArtifact application, WasTarget target, String warName, WasFileServing fileServingEnabled) {
        super(target.getCell());
        this.application = application;
        this.target = target;
        this.warName = warName;
        this.fileServingEnabled = fileServingEnabled;
        this.setDescription("Setting  File Serving Enabled to  " + warName + " in application " + application.getName() + " in cell " + target.getCell());
    }

    public boolean execute(StepExecutionContext ctx) {
        if (this.fileServingEnabled != null && this.fileServingEnabled != WasFileServing.DO_NOT_OVERRIDE) {
            return this.setFileServingEnabledPropertyOnHost(ctx);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setFileServingEnabledPropertyOnHost(StepExecutionContext ctx) {
        boolean isSuccess = true;
        String appName = this.application.getName();
        String hostPath = this.getWarWebExtFilePath();
        File localFile = this.getLocalFile(hostPath, ctx);
        HostSession session = this.target.getCell().connectToAdminHost();
        HostFile configLocationWriteFile = session.getFile(hostPath);
        String backupPath = this.getWarWebExtBackupFilePath();
        HostFile backupWriteFile = session.getFile(backupPath);
        HostSession lhs = Host.getLocalHost().getHostSession();
        try {
            FileInputStream is = new FileInputStream(localFile);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(is));
            Node mainNode = doc.getFirstChild();
            if (mainNode != null) {
                Element element = (Element)mainNode;
                NamedNodeMap attr = element.getAttributes();
                Node nodeAttr = attr.getNamedItem("fileServingEnabled");
                if (nodeAttr == null) {
                    nodeAttr = doc.createAttribute("fileServingEnabled");
                    nodeAttr.setNodeValue(this.fileServingEnabled.toString().toLowerCase());
                    attr.setNamedItem(nodeAttr);
                } else {
                    nodeAttr.setNodeValue(this.fileServingEnabled.toString().toLowerCase());
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(localFile);
                transformer.transform(source, result);
                HostFile applicationFileToUpload = lhs.getFile(localFile.getAbsolutePath());
                HostFileUtils.copy((HostFile)applicationFileToUpload, (HostFile)configLocationWriteFile);
                ctx.logOutput("Successfully updated File serving enabled property in ibm-web-ext-xmi file");
                HostFileUtils.copy((HostFile)configLocationWriteFile, (HostFile)backupWriteFile);
                ctx.logOutput("Successfully copied back up file of ibm-web-ext-xmi file");
            }
        }
        catch (IOException e) {
            ctx.logError("IO Exception occured " + appName);
            isSuccess = false;
        }
        catch (ParserConfigurationException e) {
            ctx.logError("parser configuration exception when preparing to parse binding file for app " + appName);
            isSuccess = false;
        }
        catch (SAXException e) {
            ctx.logError("SAX exception occured when parsing binding file for app " + appName);
            isSuccess = false;
        }
        catch (TransformerConfigurationException tce) {
            ctx.logError("TransformerConfiguration error occured while creating a Transformer " + appName);
            isSuccess = false;
        }
        catch (TransformerException e) {
            ctx.logError("Transformer exception in the course of transformation " + appName);
            isSuccess = false;
        }
        finally {
            localFile.delete();
            lhs.close();
            session.close();
        }
        if (!isSuccess) {
            ctx.logError("Failed to update File serving enabled property");
        }
        return isSuccess;
    }

    private String getWarWebExtBackupFilePath() {
        Date date = GregorianCalendar.getInstance().getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd-yyyy-HHmmss");
        String dateString = sdf.format(date);
        String backupPath = this.target.getCell().getConfigDirPath() + "/cells/" + this.target.getCell().getCellName() + "/applications/" + this.application.getName() + ".ear/deployments/" + this.application.getName() + "/" + this.warName + "/WEB-INF/ibm-web-ext-xmi-" + dateString + ".bk";
        return backupPath;
    }

    private String getWarWebExtFilePath() {
        String hostPath = this.target.getCell().getConfigDirPath() + "/cells/" + this.target.getCell().getCellName() + "/applications/" + this.application.getName() + ".ear/deployments/" + this.application.getName() + "/" + this.warName + "/WEB-INF/ibm-web-ext.xmi";
        return hostPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getLocalFile(String hostPath, StepExecutionContext ctx) {
        String appName = this.application.getName();
        HostSession session = this.target.getCell().connectToAdminHost();
        HostFile remoteBindingFile = session.getFile(hostPath);
        File localFile = null;
        try {
            localFile = File.createTempFile("theBindingFile", null);
            remoteBindingFile.get(localFile);
        }
        catch (IOException e) {
            ctx.logError("IO exception when copying a hostfile to a file " + localFile);
        }
        finally {
            session.close();
        }
        return localFile;
    }

    public NamedDeployableArtifact getApplication() {
        return this.application;
    }

    public String getWarName() {
        return this.warName;
    }

    public WasFileServing getFileServingEnabled() {
        return this.fileServingEnabled;
    }
}

