/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import java.util.Map;

public class RetrieveWasServerJavaVirtualMachinePropertiesStep
extends WasStepBase {
    private WasServer server;

    public RetrieveWasServerJavaVirtualMachinePropertiesStep(WasServer server) {
        super(server.getCell());
        this.server = server;
        this.setDescription("Retrieve JavaVirtualMachine properties of server " + server);
    }

    public boolean execute(StepExecutionContext ctx) {
        Map<String, String> javaVirtualMachineProperties = this.cell.getObjectInfoWithSubLevelByType(ctx, "/Server:" + this.server.getName(), "JavaVirtualMachine");
        if (javaVirtualMachineProperties == null) {
            ctx.logError("Server " + this.server + "with technical name " + this.server.getName() + " does not exist in cell " + this.cell);
            return false;
        }
        this.server.setJvmArguments(javaVirtualMachineProperties.get("genericJvmArguments"));
        this.server.setClasspath(javaVirtualMachineProperties.get("classpath"));
        this.server.setBootClasspath(javaVirtualMachineProperties.get("bootClasspath"));
        this.server.setDisableJit("true".equalsIgnoreCase(javaVirtualMachineProperties.get("disableJIT")));
        String initHeapSize = javaVirtualMachineProperties.get("initialHeapSize");
        if (initHeapSize == null) {
            this.server.setInitHeapSize(0);
        } else {
            this.server.setInitHeapSize(Integer.parseInt(initHeapSize));
        }
        String maxHeapSize = javaVirtualMachineProperties.get("maximumHeapSize");
        if (maxHeapSize == null) {
            this.server.setMaxHeapSize(0);
        } else {
            this.server.setMaxHeapSize(Integer.parseInt(maxHeapSize));
        }
        return true;
    }
}

