/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.ci.WasWmqTopicConnectionFactory;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import java.io.Serializable;
import java.util.HashMap;

public class CreateWasWmqTopicConnectionFactoryStep
extends WasStepBase
implements Step {
    private static final String CREATE_WMQ_TCF_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/create-wmq-topic-connection-factory.py";
    private WasTarget target;
    private WasWmqTopicConnectionFactory topicConnectionFactory;

    public CreateWasWmqTopicConnectionFactoryStep(WasTarget target, WasWmqTopicConnectionFactory tcf) {
        super(target.getCell());
        this.target = target;
        this.topicConnectionFactory = tcf;
        this.setDescription("Create WebSphere MQ Topic Connection Factory " + tcf + " in " + target.getShortTypeDescription() + " " + target);
    }

    public boolean execute(StepExecutionContext ctx) {
        HashMap<String, Serializable> context = new HashMap<String, Serializable>();
        context.put("tcf", this.topicConnectionFactory);
        context.put("tcfQueueManagerHost", (Serializable)this.topicConnectionFactory.getQueueManagerHost());
        String jmsProviderContainmentPath = "/" + this.target.getWasConfigIdType() + ":" + this.target.getName() + "/JMSProvider:WebSphere MQ JMS Provider";
        int res = this.executeWsadminJythonScriptResource(ctx, context, CREATE_WMQ_TCF_SCRIPT_RESOURCE_PATH, jmsProviderContainmentPath);
        return res == 0;
    }
}

