/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import java.util.List;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;

@SuppressWarnings("serial")
public abstract class ControlApplicationStep extends WasStepBase {

	protected static final String CONTROL_APPLICATION_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "control-application.py";

	protected WasTarget target;

	protected NamedDeployableArtifact application;

	protected String applicationManagerCommand;

	protected List<String> applicationManagerObjectNames;

	protected ControlApplicationStep(WasTarget target, NamedDeployableArtifact application, String applicationManagerCommand, String descriptionPrefix) {
		super(target.getCell());
		this.target = target;
		this.application = application;
		this.applicationManagerCommand = applicationManagerCommand;
		this.applicationManagerObjectNames = target.getApplicationManagerObjectNames();

		setDescription(descriptionPrefix + " " + application + " on " + target.getShortTypeDescription() + " " + target + " in cell " + cell);
	}

	public boolean execute(StepExecutionContext ctx) {
		String[] args = new String[2 + applicationManagerObjectNames.size()];
		args[0] = application.getName();
		args[1] = applicationManagerCommand;
		for (int i = 0; i < applicationManagerObjectNames.size(); i++) {
			args[i + 2] = applicationManagerObjectNames.get(i);
		}
		return executeWsadminJythonScriptResource(ctx, CONTROL_APPLICATION_SCRIPT_RESOURCE_PATH, args) == 0;
	}

}
