/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

/**
 * <h2>The <a href="http://www.xebialabs.com/deployit-automated-deployment-java-applications">Deployit</a> plugin for WebSphere Application Server.</h2>
 * 
 * This is the standard Deployit plugin for functionality related to IBM WebSphere Application
 * Server (further referenced in this documentation as WAS), optionally in combination with 
 * <a href="http://httpd.apache.org">Apache web servers &gt;= 2.x</a>. It provides support 
 * for WAS-specific components and allows users to deploy applications containing 
 * WebSphere resources to a WAS Network Deployment and Standalone environment.
 * 
 * <h3>Supported middleware</h3>
 * 
 * This plugin supports WebSphere Application Server (WAS) versions 6.1 to 7.0 in a 
 * <a href="http://www-01.ibm.com/software/webservers/appserv/was//">Standalone (hence called SA)</a>.
 * <a href="http://www-01.ibm.com/software/webservers/appserv/was/network/">Network Deployment Configuration (hence called ND)</a>.
 * 
 * <h3>Requirements</h3>
 * 
 * The plugin executes its deployment and configuration tasks by connecting to the
 * target host systems and executing WSADMIN commands there. This implies that the following
 * must be possible:
 * 
 * <ul>
 * <li>creating a connection to the host on which the "deployment manager" is running in case of a ND 
 * or where a server (server1) is running for Standalone, 
 * using the {@link com.xebialabs.deployit.ci.Host Host's} specified connection methods
 * <li>starting [WAS_PROFILE_ROOT]/[DMGR/APPSRV_PROFILE]/bin/wsadmin.sh (or on Windows wsadmin.bat) on the target host server 
 * under the user Deployit uses to connect to the host (or the SUDO user, if specified)
 * </ul>
 * 
 * In addition, if the plugin is being used in an Apache/WAS environment in order to configure the
 * Apache WebSphere plugin:
 * 
 * <ul>
 * <li>the Apache server must have the correct version of the WAS plugin installed
 * and activated (see <a href="http://publib.boulder.ibm.com/infocenter/dmndhelp/v6rxmx/index.jsp?topic=/com.ibm.websphere.nd.doc/info/ae/ae/tins_manualWebApache20.html">IBM reference documentation</a>)
 * <li>Apache must be configured to include all {@code *.conf} files in a certain directory
 * in its configuration
 * <li>it must be possible to create a connection from the Deployit server to the Apache
 * server(s) being administered
 * <li>the user under which Deployit connects to the Apache servers (or the SUDO user, if
 * specified) must be able to create, modify and delete files in the Apache configuration
 * directory referred to above
 * <li>this user must also be able to stop, start and restart Apache (uses apachectl)
 * </ul>
 * 
 * <h3>Components</h3>
 * 
 * WAS ND middleware environments are modelled on the basis of the following Configuration
 * Items (CIs):
 * 
 * <ul>
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasDeploymentManager WAS Deployment Manager}
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasNodeAgent WAS Node}
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasCluster WAS Cluster}
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasManagedServer WAS Managed Server}
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer WAS Managed Apache WebServer}
 * </ul>
 * 
 * WAS SA middleware environments are modelled on the basis of the following Configuration
 * Items (CIs):
 * 
 * <ul>
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasUnmanagedServer WAS Unmanaged Server}
 * </ul>
 * 
 * Further, the plugin provides CIs for the following WAS-related resources:
 * 
 * <ul>
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasDataSource JDBC DataSource}
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasWmqQueueConnectionFactory JMS WebSphere MQSeries Queue Connection Factory}
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasWmqTopicConnectionFactory JMS WebSphere MQSeries Topic Connection Factory}
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasWmqQueue JMS WebSphere MQSeries Queue}
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasWmqTopic JMS WebSphere MQSeries Topic}
 * </ul>
 * 
 * <h3>Supported scenarios</h3>
 * 
 * The plugin supports:
 * 
 * <ul>
 * <li>the initial deployment, re- and undeployment of deployment packages to/from WAS environments
 * via the {@link com.xebialabs.deployit.plugin.was.runbook.WasDeploymentRunBook WAS Deployment RunBook}
 * <li>the creating and deletion of Clusters and modification of their settings via
 * the {@link com.xebialabs.deployit.plugin.was.runbook.WasClusterRunBook WAS Cluster RunBook}
 * <li>the creating and deletion of Clusters and modification of their settings via
 * the {@link com.xebialabs.deployit.plugin.was.runbook.WasManagedApacheWebServerRunBook WAS Managed Apache Web Server RunBook}
 * </ul>
 * 
 * For details of the exact components supported, sequence in which steps are carried out, limitations
 * etc. please consult the documentation of the appropriate run book.
 * 
 * <h4>Mapping</h4>
 * 
 * The plugin contains the following {@link com.xebialabs.deployit.ci.artifact.DeployableArtifact Deployable artifacts} mappings: 
 * 
 * <ul>
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasEarMapping WAS Ear Mapping} maps an {@link com.xebialabs.deployit.ci.artifact.Ear EAR} to 
 * a {@link com.xebialabs.deployit.plugin.was.ci.WasCluster WAS Cluster}
 * <li>{@link com.xebialabs.deployit.plugin.was.ci.WasWarMapping WAS War Mapping} maps a {@link com.xebialabs.deployit.ci.artifact.War WAR} to 
 * a {@link com.xebialabs.deployit.plugin.was.ci.WasCluster WAS Cluster}
 * </ul>
 * 
 * <p>
 * All WAS-related resources can be mapped wit the {@link com.xebialabs.deployit.plugin.was.ci.WasResourceMapping WAS resource mapping} to:
 * 
 * <ul>
 * <li>A specified {@link com.xebialabs.deployit.plugin.was.ci.WasCluster WAS Cluster} within the target {@link com.xebialabs.deployit.plugin.was.ci.WasDeploymentManager WAS Cell}.
 * </ul>
 * 
 * <h3>Known limitations</h3>
 * 
 * The plugin does not currently support
 * 
 * <ul>
 * <li>Installation, maintenance or removal of WebSphere installations and profiles.
 * </ul>
 * 
 * If you have questions, comments or feedback please <a href="mailto:deployit-dev@xebialabs.com">contact</a>
 * the WebSphere development team at XebiaLabs.
 * 
 * @version 1.2
 */
package com.xebialabs.deployit.plugin.was;