#
def startApplication(appName, appEditionName, cellName, serverName, nodeName):
    try:
        appMgrName = "cell=%s,node=%s,type=ApplicationManager,process=%s,*" % (cellName, nodeName, serverName)
        appMgr = AdminControl.queryNames(appMgrName)
        if appMgr == '':
            print "Cannot (completely) start %s because the server %s has not been started." % (appEditionName, serverName)
            return False
        else:
            AdminControl.invoke(appMgr, 'startApplication', '["' + appEditionName + '"]')
            print "Done."
    except:
        #Zendesk 406: SOAP timeout
        if isApplicationRunningOnServer(appName, serverName, nodeName):
            print "An exception occurred while starting Application", appName, "on", serverName, ", but it appears to have started anyway."
        else:
            raise
    return True

def waitForApplicationDistribution():
    # Wait for application to be installed
    count = 0
    while count < deployed.retryAttemptsForAppReadyCheck:
        if AdminApp.isAppReady(appEditionName) == 'true':
            print "\nApplication distribution complete."
            break
        count = count + 1
        print "\nApplication distribution not complete, will recheck in 10 seconds. Attempt %s of %s." % (count, deployed.retryAttemptsForAppReadyCheck)
        time.sleep(10)
    if count == deployed.retryAttemptsForAppReadyCheck:
        print "WebSphere failed to indicate if application was fully distributed. Will attempt to start application..."

def startApplicationOnCluster():
    if not isClusterRunning(deployed.container.name):
        printErrorAndExit("Cluster %s is not running therefore application cannot be started." % deployed.container.name)

    clusterId = AdminConfig.getid("/ServerCluster:%s/" % deployed.container.name)
    clusterMembers = wsadminToList(AdminConfig.list("ClusterMember", clusterId))
    if len(clusterMembers) == 0:
        print "WARNING: did not detect any members in cluster %s" % deployed.container.name
    serversWithRunningApplication = 0
    for server in clusterMembers:
        serverName = AdminConfig.showAttribute(server,"memberName")
        serverObjectName = AdminControl.completeObjectName('WebSphere:type=Server,name=%s,*' % serverName)
        if serverObjectName is None or serverObjectName == "":
            printError("Server %s is not running therefore application cannot be started on this server. Ignoring..." % serverName)
            continue
        serverNodeName = AdminControl.getAttribute(serverObjectName, 'nodeName')
        if isApplicationRunningOnServer(deployed.name, serverName, serverNodeName):
            print "Application", deployed.name, "on", serverName, "already started."
            serversWithRunningApplication += 1
        else:
            print "Starting application", deployed.name, "on", serverName
            if startApplication(deployed.name, appEditionName, deployed.container.cellName, serverName, serverNodeName):
                serversWithRunningApplication += 1
    if serversWithRunningApplication < len(clusterMembers):
        if hasattr(deployed.container, "failOnPartialApplicationStart") and deployed.container.failOnPartialApplicationStart:
            printErrorAndExit("Application %s only partially started (running on %s of %s cluster members)" % (deployed.name, serversWithRunningApplication, len(clusterMembers)))
        else:
            print "WARN: Application %s only partially started (running on %s of %s cluster members)" % (deployed.name, serversWithRunningApplication, len(clusterMembers))

def startApplicationOnServer():
    if not isServerRunning(deployed.container.nodeName, deployed.container.name):
        printErrorAndExit("Server %s is not running therefore application cannot be started." % deployed.container.name)

    if isApplicationRunningOnServer(deployed.name, deployed.container.name, deployed.container.nodeName):
        print "Application", deployed.name, "on", deployed.container.name, "already started."
    else:
        print "Starting application", deployed.name, "on",  deployed.container.name
        if not startApplication(deployed.name, appEditionName, deployed.container.cellName, deployed.container.name, deployed.container.nodeName):
            printErrorAndExit("Unable to start application %s" % deployed.name)


appEditionName = getApplicationEditionName(deployed)
waitForApplicationDistribution()
if (deployed.container.wasTargetType == "cluster"):
    startApplicationOnCluster()
else:
    startApplicationOnServer()
