#######################################################################
# Common callback functions
#######################################################################
def j2eePropertiesConfigCallback(resourceId, deployed, props):
    if hasattr(deployed, 'customProperties'):
        removeJ2EEResourceProperties(resourceId)
        createJ2EEResourceProperties(resourceId, deployed)

def propertiesConfigCallback(resourceId, deployed, props):
    if hasattr(deployed, 'customProperties'):
        customProperties = wsadminToList(AdminConfig.list("Property", resourceId))
        for customPropId in customProperties:
            print "Removing Custom Property %s" % customPropId
            AdminConfig.remove(customPropId)
        createCustomProps(resourceId, "Property", deployed)

def customPropertiesConfigCallback(resourceId, deployed, props):
    if hasattr(deployed, 'customProperties'):
        if "propertySet" in getConfigTypeAttrs(deployed.wasType):
            j2eePropertiesConfigCallback(resourceId, deployed, props)
        else:
            propertiesConfigCallback(resourceId, deployed, props)

#######################################################################
# Common getter functions
#######################################################################
def getContainer(deployed):
    if hasattr(deployed, 'providerType'):
        providerId = AdminConfig.getid("%s/%s:%s" % (deployed.container.containmentPath, deployed.providerType, deployed.provider))
        return validateNotEmpty(providerId, "Cannot find %s '%s' on container '%s'" % (deployed.providerType, deployed.provider, deployed.container.name))
    else:
        containerId = AdminConfig.getid(deployed.container.containmentPath)
        return validateNotEmpty(containerId, "Cannot find target container '%s' at containment path '%s'" % (deployed.container.name, deployed.container.containmentPath))

def getResource(deployed):
    if hasattr(deployed, 'providerType'):
        return AdminConfig.getid("%s/%s:%s/%s:%s" % (deployed.container.containmentPath, deployed.providerType, deployed.provider, deployed.wasType, deployed.name))
    else:
        return AdminConfig.getid("%s/%s:%s" % (deployed.container.containmentPath, deployed.wasType, deployed.name))

#######################################################################
# AdminConfig CRUD functions
#######################################################################
def create(deployed, props=None, additionalConfigCallback=customPropertiesConfigCallback):
    containerId = getContainer(deployed)
    if not props:
        props = deployed.getExposedProperties(True)
    args = toAdminConfigArgs(props)
    propsDuplicate = props
    if props.has_key('stringToBind'):
        del propsDuplicate['stringToBind']
    printingArgs = toAdminConfigArgs(propsDuplicate)
    print "Creating %s '%s' in container '%s' with args '%s'" % (deployed.wasType, deployed.name, deployed.container.name, printingArgs)
    resourceId = adminConfigCreate(deployed.wasType, containerId, args)
    if additionalConfigCallback:
        additionalConfigCallback(resourceId, deployed, props)

def modify(deployed, props=None, additionalConfigCallback=customPropertiesConfigCallback, resourceId=None):
    if not resourceId:
        resourceId = getResource(deployed)
    validateNotEmpty(resourceId, "Cannot find %s '%s' on container '%s'" % (deployed.wasType, deployed.name, deployed.container.name))
    if not props:
        props = deployed.getExposedProperties(True)
    args = toAdminConfigArgs(props)
    propsDuplicate = props
    if props.has_key('stringToBind'):
        del propsDuplicate['stringToBind']
    printingArgs = toAdminConfigArgs(propsDuplicate)
    print "Modifying %s '%s' in container '%s' with args '%s'" % (deployed.wasType, deployed.name, deployed.container.name, printingArgs)
    unsetAttributes(resourceId, props.keys())
    adminConfigModify(resourceId, args)

    if additionalConfigCallback:
        additionalConfigCallback(resourceId, deployed, props)

def createOrModify(deployed, props=None, additionalConfigCallback=customPropertiesConfigCallback):
    resourceId = getResource(deployed)
    if not resourceId:
        create(deployed, props, additionalConfigCallback)
    else:
        modify(deployed, props, additionalConfigCallback, resourceId)

def destroy(deployed):
    resourceId = getResource(deployed)
    if resourceId:
        print "Destroying %s '%s' in container '%s'" % (deployed.wasType, deployed.name, deployed.container.name)
        AdminConfig.remove(resourceId)
    else:
        print "No %s '%s' found, nothing to do" % (deployed.wasType, deployed.name)

def listResources(container, prototype):
    if hasattr(prototype, 'providerType'):
        return wsadminToList(AdminConfig.getid('%s/%s:/%s:/' % (container.containmentPath, prototype.providerType, prototype.wasType)))
    else:
        return wsadminToList(AdminConfig.getid('%s/%s:/' % (container.containmentPath, prototype.wasType)))

def inspectResource(deployedId, deployedName, resourceId, prototype):
    inspectDeployedProperties(deployedId, deployedName, resourceId, prototype)
    if hasattr(prototype, "provider") and "provider" in getConfigTypeAttrs(prototype.wasType):
        providerId = AdminConfig.showAttribute(resourceId, "provider")
        if providerId:
            inspectedProperty(deployedId, "provider", AdminConfig.showAttribute(providerId, "name"))
    if hasattr(prototype, "customProperties"):
        customProperties = wsadminToList(AdminConfig.list("J2EEResourceProperty", resourceId))
        if not customProperties:
            customProperties = wsadminToList(AdminConfig.list("Property", resourceId))
        inspectCustomProperties(deployedId, customProperties, "customProperties")

def discoverAndInspectResources(container, prototype, listObjectsInContainerCallback=listResources, adminConfigPropertyTypeInspectCallback=inspectResource, appendTypeToName=False, stringEncoding=None):
    for c in findAllContainers(container):
        inspectAdminConfigPropertiesCallback(c, prototype, None, adminConfigPropertyTypeInspectCallback, listObjectsInContainerCallback, appendTypeToName, stringEncoding)