#
def createJ2CAdminObject(props, deployed):
    args = toAdminTaskArgs(props)
    providerId = getJ2CResourceAdapter(deployed)
    print "Creating %s for resource adapter '%s' with args '%s' in container '%s'" % (deployed.wasType, deployed.provider, args, deployed.container.name)
    objectId = AdminTask.createJ2CAdminObject(providerId, args)
    if hasattr(deployed, "customProperties"):
        createOrUpdateCustomProps(objectId, "J2EEResourceProperty", deployed)

def inspectJ2CAdminObject(deployedId, deployedName, resourceId, prototype):
    inspectDeployedProperties(deployedId, deployedName, resourceId, prototype, ignoredProperties = ["name", "adminObjectInterface"])

    providerId = getParentOfType(resourceId, prototype.wasType, "J2CResourceAdapter")
    validateNotEmpty(providerId, "Unable to find parent for %s '%s'" % (prototype.wasType, resourceId))
    inspectedProperty(deployedId, "provider", AdminConfig.showAttribute(providerId, "name"))

    adminObjectId = AdminConfig.showAttribute(resourceId, "adminObject")
    if adminObjectId:
        inspectedProperty(deployedId, "adminObjectInterface", AdminConfig.showAttribute(adminObjectId, "adminObjectInterface"))

    nestedProperties = wsadminToList(AdminConfig.showAttribute(resourceId, "properties"))
    inspectCustomProperties(deployedId, nestedProperties, "customProperties")