/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.container;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.python.DerivedProperty;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

import static com.google.common.collect.Sets.newHashSet;

@SuppressWarnings("serial")
@Metadata(description = "An unmanaged Webpshere node represents a node in the topology that does not have an application server process or a node agent process. Unmanaged nodes are for other server processes, such as web servers that exist on their own node in the topology.")
public class UnmanagedNode extends BaseContainer implements Node {

    @Property(required = false, asContainment = false, description = "Host on which the NodeAgent server runs. If not defined it will default to the host associated with deployment manager.")
    private Host host;

    @Property(required = true, asContainment = true, label = "Deployment manager that contains this unmanaged node")
    private DeploymentManager cell;

    @Property(description = "WebSphere web servers in the node", asContainment = true, required = false)
    private Set<ManagedWebServer> webServers = newHashSet();


    @Override
    public Host getHost() {
        Host hostValue = getProperty("host");
        if (null == hostValue) {
            // if 'host' property is null then fallback to default
            hostValue = getCell().getHost();
        }

        return hostValue;
    }

    public List<Step> controlTaskDispatch(String name, Map<String, String> args) {
        return ControlTaskDelegate.dispatch(name, args, this, this);
    }

    public Set<ManagedWebServer> getWebServers() {
        return webServers;
    }

    public void addWebServer(ManagedWebServer webServer) {
        webServers.add(webServer);
    }

    @Override
    public DeploymentManager getCell() {
        return cell;
    }

    public void setCell(DeploymentManager cell) {
        this.cell = cell;
    }

    @Override
    public PythonManagingContainer getManagingContainer() {
        return getCell();
    }

    @Override
    public String getCellName() {
        return getCell().getCellName();
    }

    @Override
    public Set<Node> getNodes() {
        return Collections.singleton((Node) this);
    }

    @Override
    @DerivedProperty("nodeName")
    public String getNodeName() {
        return getName();
    }

    @Override
    public String getContainmentPath() {
        return "/Node:" + getName();
    }

    @Override
    public String getShortTypeDescription() {
        return "node";
    }

    @Override
    public String getWasConfigIdType() {
        return "Node";
    }

    @Override
    public String getWasTargetType() {
        return "Node";
    }

    public void setHost(Host host){ this.host = host; }
}