#
def createJ2CActivationSpec(props, deployed):
    args = toAdminTaskArgs(props)
    providerId = getJ2CResourceAdapter(deployed)
    print "Creating %s for resource adapter '%s' with args '%s' in container '%s'" % (deployed.wasType, deployed.provider, args, deployed.container.name)
    objectId = AdminTask.createJ2CActivationSpec(providerId, args)
    if hasattr(deployed, "customProperties"):
        createOrUpdateCustomProps(objectId, "J2EEResourceProperty", deployed)

def inspectJ2CActivationSpec(deployedId, deployedName, resourceId, prototype):
    inspectDeployedProperties(deployedId, deployedName, resourceId, prototype, ignoredProperties = ["name", "messageListenerType"])

    providerId = getParentOfType(resourceId, prototype.wasType, "J2CResourceAdapter")
    validateNotEmpty(providerId, "Unable to find parent for %s '%s'" % (prototype.wasType, resourceId))
    inspectedProperty(deployedId, "provider", AdminConfig.showAttribute(providerId, "name"))
    messageListenerTypes = wsadminToList(AdminTask.listMessageListenerTypes(providerId))
    if len(messageListenerTypes) > 0:
        inspectedProperty(deployedId, "messageListenerType", messageListenerTypes[0])

    nestedProperties = wsadminToList(AdminConfig.showAttribute(resourceId, "resourceProperties"))
    inspectCustomProperties(deployedId, nestedProperties, "customProperties")