#
targetId = getTarget(deployed, deployed.container)
existing = {}
for entry in getProperties(deployed, deployed.container, targetId):
    name = AdminConfig.showAttribute(entry, "name")
    existing[name] = entry

if deployed.removeNotPresent:
    for existingName, existingId in existing.items():
        if not deployed.properties.has_key(existingName):
            print "Removing custom property '%s'" % existingName
            AdminConfig.remove(existingId)

for key, value in deployed.properties.items():
    attr = [["name", key], ["value", value]]
    if existing.has_key(key):
        if deployed.overwriteExisting:
            print "Overwriting custom property %s = %s" % (key, value)
            adminConfigModify(existing[key], attr)
        else:
            currentValue = AdminConfig.showAttribute(existing[key], "value")
            print "Appending '%s' to existing custom property %s = %s" % (value, key, currentValue)
            adminConfigModify(existing[key], [["name", key], ["value", currentValue + value]])
    else:
        print "Adding custom property %s = %s" % (key,value)
        adminConfigCreate("Property", targetId, attr)