/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.python.DerivedProperty;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.DeploymentManager;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import com.xebialabs.deployit.plugin.was.container.Node;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(description="An unmanaged Webpshere node represents a node in the topology that does not have an application server process or a node agent process. Unmanaged nodes are for other server processes, such as web servers that exist on their own node in the topology.")
public class UnmanagedNode
extends BaseContainer
implements Node {
    @Property(required=false, asContainment=false, description="Host on which the NodeAgent server runs. If not defined it will default to the host associated with deployment manager.")
    private Host host;
    @Property(required=true, asContainment=true, label="Deployment manager that contains this unmanaged node")
    private DeploymentManager cell;
    @Property(description="WebSphere web servers in the node", asContainment=true, required=false)
    private Set<ManagedWebServer> webServers = Sets.newHashSet();

    public Host getHost() {
        Host hostValue = (Host)this.getProperty("host");
        if (null == hostValue) {
            hostValue = this.getCell().getHost();
        }
        return hostValue;
    }

    public List<Step> controlTaskDispatch(String name, Map<String, String> args) {
        return ControlTaskDelegate.dispatch((String)name, args, (ConfigurationItem)this, (Container)this);
    }

    public Set<ManagedWebServer> getWebServers() {
        return this.webServers;
    }

    public void addWebServer(ManagedWebServer webServer) {
        this.webServers.add(webServer);
    }

    @Override
    public DeploymentManager getCell() {
        return this.cell;
    }

    public void setCell(DeploymentManager cell) {
        this.cell = cell;
    }

    public PythonManagingContainer getManagingContainer() {
        return this.getCell();
    }

    @Override
    public String getCellName() {
        return this.getCell().getCellName();
    }

    public Set<Node> getNodes() {
        return Collections.singleton(this);
    }

    @Override
    @DerivedProperty(value="nodeName")
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public String getContainmentPath() {
        return "/Node:" + this.getName();
    }

    @Override
    public String getShortTypeDescription() {
        return "node";
    }

    @Override
    public String getWasConfigIdType() {
        return "Node";
    }

    @Override
    public String getWasTargetType() {
        return "Node";
    }

    public void setHost(Host host) {
        this.host = host;
    }
}

