def discoverAndInspectServerPort(container):
    containerId = AdminConfig.getid(container.containmentPath)
    serverName = container.name
    if (container.wasConfigIdType == 'Server'):
        cellName = container.cellName
        nodeName = container.nodeName
        nodeId = AdminConfig.getid('/Cell:%s/Node:%s/' % (cellName, nodeName))
        serverEntries = wsadminToList(AdminConfig.list('ServerEntry', nodeId))
        for serverEntry in serverEntries :
            sName = AdminConfig.showAttribute(serverEntry, "serverName")
            if sName == serverName:
                namedEndPoints = wsadminToList(AdminConfig.list("NamedEndPoint" , serverEntry))
                for namedEndPoint in namedEndPoints:
                    endPointName = AdminConfig.showAttribute(namedEndPoint, "endPointName")
                    endPoint = AdminConfig.showAttribute(namedEndPoint, "endPoint")
                    if appendTypeToName:
                        deployedId = container.id + '/' + endPointName + '_' + prototype.type
                    else:
                        deployedId = container.id + '/' + endPointName
                    discovered(deployedId, prototype.type)
                    inspectedProperty(deployedId, 'wasName', endPointName)
                    inspectDeployedProperties(deployedId, endPointName, endPoint, prototype)
                    inspectedItem(deployedId)

for c in findAllContainers(container, onlyWasAppContainer=True):
    discoverAndInspectServerPort(c)
