healthPolicyName = deployed.name
healthPolicy = validateNotEmpty(findHealthPolicy(healthPolicyName), "Health policy '%s' not found" % (healthPolicyName))

props = deployed.getExposedProperties(True)
props['reactionMode'] = reactionModeToWasMap[props['reactionMode']]
args = toAdminConfigArgs(props)

checkHealthCondition(deployed)

cellId = AdminConfig.getid('/Cell:' + deployed.container.cellName + '/')

print "Modifying Health Policy '%s' for '%s': %s" % (healthPolicyName, deployed.container.name, args)
adminConfigModify(healthPolicy, args)

deleteHealthCondition(healthPolicy)
createHealthCondition(healthPolicy, deployed.condition[0])

deleteHealthActions(healthPolicy)
if hasattr(deployed, 'healthActions'):
    createHealthActions(healthPolicyName, deployed.healthActions)
