# Discover was.VirtualHost instances - skip VirtualHost that live on a Node
virtualhosts = AdminConfig.list('VirtualHost')
if virtualhosts != "":
    for virtualhost in virtualhosts.splitlines():
        if virtualhost.find('/nodes/') == -1:
            virtualHostName = AdminConfig.showAttribute(virtualhost, 'name')
            if appendTypeToName:
                virtualHostId = '%s/%s' % (container.id, virtualHostName) + '_was.VirtualHost'
            else:
                virtualHostId = '%s/%s' % (container.id, virtualHostName)
            discovered(virtualHostId, 'was.VirtualHost')
            inspectedProperty(virtualHostId, 'wasName', virtualHostName)

            virtualHostContainmentPath = '/Cell:%s/VirtualHost:%s' % (container.cellName, virtualHostName)
            virtualHostAliases = AdminConfig.getid(virtualHostContainmentPath + '/HostAlias:/').split()
            # BUG FIX: When no alias defined, Websphere defaults to *:80.  See https://www.ibm.com/support/knowledgecenter/SSEQTP_8.5.5/com.ibm.websphere.base.doc/ae/ccws_vhost.html)
            if len(virtualHostAliases) > 0:
                inspectedProperty(virtualHostId, 'aliases', [AdminConfig.showAttribute(a, 'hostname') + ':' + AdminConfig.showAttribute(a, 'port') for a in virtualHostAliases if a != ""])
            else:
                inspectedProperty(virtualHostId, 'aliases', ['*:80'])
            inspectedItem(virtualHostId)
