/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.validation.Range;
import com.xebialabs.deployit.plugin.python.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.was.container.BaseCluster;
import com.xebialabs.deployit.plugin.was.container.ManagedServer;
import com.xebialabs.deployit.plugin.was.deployable.DynamicClusterSpec;
import com.xebialabs.deployit.plugin.was.util.OperationalMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(description="A WebSphere dynamic cluster managed by a WebSphere deployment manager (WAS ND)")
public class DynamicCluster
extends BaseCluster<DynamicClusterSpec> {
    @Property(label="Membership policy", defaultValue="node_nodegroup = 'DefaultNodeGroup'", description="Specify an expression that is used to define which nodes are used for the dynamic cluster.Ex:node_nodegroup = 'my_node_group'")
    private String membershipPolicy;
    @Property(required=true, label="Maximum number of cluster instances", defaultValue="-1", description="Choose the Maximum number of instances to have running when the dynamic cluster is activated,The Default is -1(Do not limit the number of instances that can start)")
    @Range(minimum=-1, message="The Maximum number of instances must be greater than -1")
    private int maxInstances;
    @Property(required=true, label="Minimum number of cluster instances", defaultValue="1", description="Choose the minimum number of instances to have running when the dynamic cluster is activated,The Default is 1")
    @Range(minimum=0, message="The minimum number of instances must be a positive value")
    private int minInstances;
    @Property(required=true, label="Vertical stacking of instances on node", defaultValue="0", description="If the nodes in the dynamic cluster have extra capacity, vertical stacking allows an application to make more effective use of the capacity by starting multiple instances on the same node,The Default is 0")
    @Range(minimum=0, message="The vertical stacking number of instances must be a positive value.")
    private int numVerticalInstances;
    @Property(required=false, label="Cluster members", description="Servers that are part of this cluster", hidden=true)
    private Set<ManagedServer> servers;
    @Property(required=false, defaultValue="MANUAL", description="Specifies the level that the dynamic cluster interacts with the dynamic operations environment.")
    private OperationalMode operationalMode;
    @Property(required=false, defaultValue="was/container/create-dynamic-cluster.py", hidden=true)
    private String createPythonScript;
    @Property(required=false, defaultValue="was/container/modify-dynamic-cluster.py", hidden=true)
    private String modifyPythonScript;
    @Property(required=false, defaultValue="was/container/destroy-dynamic-cluster.py", hidden=true)
    private String destroyPythonScript;

    public String getMembershipPolicy() {
        return this.membershipPolicy;
    }

    public void setMembershipPolicy(String membershipPolicy) {
        this.membershipPolicy = membershipPolicy;
    }

    public int getMinInstances() {
        return this.minInstances;
    }

    public void setMinInstances(int minInstances) {
        this.minInstances = minInstances;
    }

    public int getMaxInstances() {
        return this.maxInstances;
    }

    public void setMaxInstances(int maxInstances) {
        this.maxInstances = maxInstances;
    }

    public int getNumVerticalInstances() {
        return this.numVerticalInstances;
    }

    public void setNumVerticalInstances(int numVerticalInstances) {
        this.numVerticalInstances = numVerticalInstances;
    }

    public OperationalMode getOperationalMode() {
        return this.operationalMode;
    }

    public void setOperationalMode(OperationalMode operationalMode) {
        this.operationalMode = operationalMode;
    }

    @Override
    public String getContainmentPath() {
        return "/ServerCluster:" + this.getName();
    }

    @Override
    public String getWasConfigIdType() {
        return "DynamicCluster";
    }

    public String getCreatePythonScript() {
        return this.createPythonScript;
    }

    public void setCreatePythonScript(String createPythonScript) {
        this.createPythonScript = createPythonScript;
    }

    public String getModifyPythonScript() {
        return this.modifyPythonScript;
    }

    public void setModifyPythonScript(String modifyPythonScript) {
        this.modifyPythonScript = modifyPythonScript;
    }

    public String getDestroyPythonScript() {
        return this.destroyPythonScript;
    }

    public void setDestroyPythonScript(String destroyPythonScript) {
        this.destroyPythonScript = destroyPythonScript;
    }

    @ControlTask(label="Create", description="This control task is used to create a new DynamicCluster")
    public List<Step> create() {
        return this.invokeControlTask("create");
    }

    @ControlTask(label="Modify", description="This control task is used to modify the properties of an existing DynamicCluster")
    public List<Step> modify() {
        return this.invokeControlTask("modify");
    }

    @ControlTask(label="Destroy", description="This control task is used to destroy an existing DynamicCluster")
    public List<Step> destroy() {
        return this.invokeControlTask("destroy");
    }

    private List<Step> invokeControlTask(String name) {
        HashMap args = Maps.newHashMap();
        return ControlTaskDelegate.dispatch((String)name, (Map)args, (ConfigurationItem)this, (Container)this);
    }
}

