package com.xebialabs.deployit.plugin.was.contributor.webserver;


import java.util.Set;

import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import com.xebialabs.deployit.plugin.was.contributor.webserver.task.ManagedWebServerTasks;

import static java.lang.Boolean.TRUE;

public class WebServerPluginConfigurationContributor extends AbstractReferencedWebserverContributor {
    private static final String WEBSERVER_UPDATE_PLUGIN_PROPERTY = "updatePlugin";

    /**
     * GenerateAndPropagateWebserverPlugin#generateAndPropagateWebserverPlugin contributor will add steps to generate
     * and propagate plugin-cfg.xml for all web servers that have "updatePlugin" property set to TRUE and are referenced
     * by created or removed ear and war modules in the current deployment plan.
     */
    @Contributor
    public static void generateAndPropagateWebserverPlugin(Deltas deltas, DeploymentPlanningContext ctx) {
        WebServerPluginConfigurationContributor contributor = new WebServerPluginConfigurationContributor();
        contributor.filterDeltas(deltas.getDeltas());

        Set<ManagedWebServer> referencedWebservers = contributor.getReferencedWebservers(ctx);

        for (ManagedWebServer webserver : referencedWebservers) {
            // may be null
            if (TRUE.equals(webserver.getProperty(WEBSERVER_UPDATE_PLUGIN_PROPERTY))) {
                ManagedWebServerTasks.generatePlugin(webserver, ctx);
                ManagedWebServerTasks.propagatePlugin(webserver, ctx);
            }
        }
    }
}
