protocols = [ 'BootstrapBasicMessaging', 'BootstrapSecureMessaging',
    'BootstrapTunneledMessaging', 'BootstrapTunneledSecureMessaging',
    'OutboundBasicMQLink', 'OutboundSecureMQLink',
    'OutboundBasicWMQClient', 'OutboundSecureWMQClient',
    'InboundBasicMessaging', 'InboundSecureMessaging',
    'InboundBasicMQLink', 'InboundSecureMQLink'
]

def deCapitalize(s):
    if len(s) == 0:
        return s
    else:
        return s[0].lower() + s[1:]

def siBusExists(busName):
    ids = wsadminToList(AdminTask.listSIBuses())
    matching = [id for id in ids if AdminConfig.showAttribute(id, 'name') == busName]
    return len(matching) > 0

def getPermittedTransports(busName):
    transports = {}
    permittedChains = wsadminToList(AdminTask.listSIBPermittedChains(['-bus', busName]))

    for chainId in permittedChains:
        chain = AdminConfig.showAttribute(chainId, 'name')
        if chain in protocols:
            transports[chain] = chainId
        else:
            print "WARN: unsupported chain found '%s' in Service Integration Bus '%s'" % (chain, busName)
    return transports

def updatePermittedTransports(deployed):
    permittedTransports = getPermittedTransports(busName)
    if deployed.permittedChains != 'LISTED':
        for name, id in permittedTransports.items():
            print "Removing '%s' from the allowed protocols" % name
            AdminConfig.remove(id)
        print "Setting permitted chains to '%s'" % deployed.permittedChains
    else:
        for protocol in protocols:
            propName = deCapitalize(protocol)
            shouldBeSet = getattr(deployed.permittedTransport, propName)
            if shouldBeSet and not protocol in permittedTransports.keys():
                print "Adding '%s' to the allowed protocols" % protocol
                AdminTask.addSIBPermittedChain(['-bus', busName, '-chain', protocol])
            elif not shouldBeSet and protocol in permittedTransports.keys():
                print "Removing '%s' from the allowed protocols" % protocol
                AdminConfig.remove(permittedTransports[protocol])

def getBusProperties(bus):
    props = {}

    busName = AdminConfig.showAttribute(bus, 'name')
    props['busName'] = busName

    description = AdminConfig.showAttribute(bus, 'description')
    props['description'] = description

    data = AdminTask.showSIBus(['-bus', busName])
    data = data[1:-1]
    # get rid of description & name so chances are less of encountering invalid ','
    data = data.replace(', description=%s' % description, '', 1)
    data = data.replace(', busName=%s' % busName, '', 1)
    for kv in data.split(', '):
        key, value = kv.split('=', 1)
        props[key] = value

    # secure is deprecated, set as busSecurity read as secure.
    if not props.has_key('busSecurity'):
        props['busSecurity'] = props['secure']

    return props

def getAllowedProtocols(deployed):
    allowedProtocols = []
    for protocol in protocols:
        propName = deCapitalize(protocol)
        if getattr(deployed.permittedTransport, propName):
            allowedProtocols.append(protocol)
    return allowedProtocols

def checkAllowedTransports(deployed):
    if deployed.permittedChains == 'LISTED':
        allowedProtocols = getAllowedProtocols(deployed)
        if len(allowedProtocols) == 0:
            printErrorAndExit("ERROR: permittedChains is 'LISTED' but no permittedTransports selected")
    if deployed.permittedChains == 'ALL':
        allowedProtocols = protocols
    elif deployed.permittedChains == 'SSL_ENABLED':
        allowedProtocols = [p for p in protocols if p.find('Secure') != -1]

    # protocol is optional
    if not hasattr(deployed, 'protocol') or not deployed.protocol:
        return allowedProtocols

    if deployed.protocol not in protocols:
        printErrorAndExit("ERROR: Unknown protocol specified '%s' possible protocols: %s" % (deployed.protocol, protocols))

    if deployed.protocol not in allowedProtocols:
        printErrorAndExit("ERROR: Protocol '%s' not found in the list of permitted protocols: %s\neither add the protocol to the permitted ones, or specify a protocol in the permitted protocol list" % (deployed.protocol, allowedProtocols))

    return allowedProtocols
