/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.util;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WasVersionInfoParser {
    public int majorVersion = -1;
    public int minorVersion = -1;
    private final String versionInfoNameField;

    public WasVersionInfoParser(String versionInfoNameField) {
        this.versionInfoNameField = versionInfoNameField;
    }

    public WasVersionInfoParser parse(List<String> versionInfoOutput) {
        boolean scanningWasInfo = false;
        for (String eachLine : versionInfoOutput) {
            String[] matches;
            if (eachLine.startsWith(this.versionInfoNameField)) {
                matches = WasVersionInfoParser.regexMatch(eachLine, this.versionInfoNameField + "\\s+(\\w.+)");
                if (matches != null && matches.length == 1 && matches[0].startsWith("IBM WebSphere Application Server")) {
                    scanningWasInfo = true;
                    continue;
                }
                scanningWasInfo = false;
                continue;
            }
            if (!scanningWasInfo || !eachLine.startsWith("Version") || (matches = WasVersionInfoParser.regexMatch(eachLine, "Version\\s+(\\d+)\\.(\\d+)\\.[\\d\\.]*")) == null || matches.length != 2) continue;
            this.majorVersion = Integer.parseInt(matches[0]);
            this.minorVersion = Integer.parseInt(matches[1]);
            return this;
        }
        return this;
    }

    public WasVersionInfoParser parse(String[] versionInfoOutput) {
        return this.parse(Arrays.asList(versionInfoOutput));
    }

    public boolean isSuccess() {
        return this.majorVersion != -1 && this.minorVersion != -1;
    }

    private static String[] regexMatch(String str, String regexPattern) {
        Matcher m = Pattern.compile(regexPattern).matcher(str);
        if (m.matches()) {
            String[] matches = new String[m.groupCount()];
            for (int i = 0; i < matches.length; ++i) {
                matches[i] = m.group(i + 1);
            }
            return matches;
        }
        return null;
    }
}

