/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Preview;
import com.xebialabs.deployit.plugin.api.flow.PreviewStep;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.rules.RulePostConstruct;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.rules.StepParameter;
import com.xebialabs.deployit.plugin.api.rules.StepPostConstructContext;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.steps.CalculatedStep;
import com.xebialabs.deployit.plugin.steps.ContextHelper;
import com.xebialabs.deployit.plugin.steps.TargetContainerJavaHelper;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;
import java.util.HashMap;
import java.util.Map;

@StepMetadata(name="wsadmin")
public class WsadminStep
extends CalculatedStep
implements PreviewStep,
SatelliteAware {
    @StepParameter(description="WAS cell where the Python script will be executed.", calculated=true)
    private Cell targetCell;
    @StepParameter(description="Path to the Python script to execute.")
    private String script;
    @StepParameter(description="Dictionary that represents the context available to the Python script.", required=false, calculated=true)
    private Map<String, Object> pythonContext = new HashMap<String, Object>();
    @StepParameter(description="If true, the artifacts from the Python context will be uploaded to the target host and will be available to the script as bindingName.file. Defaults to true.")
    private Boolean uploadArtifactsInPythonContext = true;
    private PythonDeploymentStep pythonStep;

    @RulePostConstruct
    public void doPostConstruct(StepPostConstructContext ctx) {
        super.doPostConstruct(ctx);
        this.pythonStep = new PythonDeploymentStep(this.getOrder(), (PythonManagingContainer)this.calculateTargetCell(ctx), this.script, ContextHelper.defaultContext((StepPostConstructContext)ctx, this.pythonContext), this.getDescription());
        this.pythonStep.setUploadArtifactData(this.uploadArtifactsInPythonContext.booleanValue());
    }

    private Cell calculateTargetCell(StepPostConstructContext ctx) {
        PythonManagedContainer targetContainer;
        if (this.targetCell == null && (targetContainer = (PythonManagedContainer)TargetContainerJavaHelper.defaultTargetContainer((StepPostConstructContext)ctx, PythonManagedContainer.class)) != null && targetContainer.getManagingContainer() instanceof Cell) {
            this.targetCell = (Cell)targetContainer.getManagingContainer();
        }
        return this.targetCell;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        return this.pythonStep.execute(ctx);
    }

    public Preview getPreview() {
        return this.pythonStep.getPreview();
    }

    public Satellite getSatellite() {
        return this.targetCell.getHost().getSatellite();
    }
}

