import random

def findNodes(container):
    nodes = []
    if container.type in ["was.DeploymentManager"]:
        for node in container.nodeAgents:
            nodes.append(node)
    elif container.type in ["was.NodeAgent"]:
        nodes.append(container)
    elif container.type in ["was.Cluster", "was.DynamicCluster"]:
        for server in container.servers:
            nodes.append(server.node)
    elif container.type in ["was.ManagedServer"]:
        nodes.append(container.node)
    return nodes

nodePaths = ""

for d in deltas.deltas:
    if d.operation in ["CREATE"]:
        deployed = d.deployed
        if deployed.type == "was.J2CResourceAdapter":
            for node in findNodes(deployed.container):
                nodePath = "%s/config/temp/%s/upload/%s" % (node.userInstallRoot,
                                                                 random.randint(10000000, 99999999),
                                                                 deployed.file.name)
                nodePaths += "%s/%s=%s\n" % (node.name, deployed.name, nodePath)

                if node.host == None:
                    raise Exception("Please make sure that the host is configured under: '%s'. " % (str(deployed).rsplit('/', 1)[0]))

                if node.userInstallRoot == None:
                    raise Exception("Please make sure that the user install root is configured under: '%s'. " % (str(deployed).rsplit('/', 1)[0]))

                context.addStep(steps.upload(
                    artifact = deployed,
                    target_host = node.host,
                    target_path = nodePath,
                    create_target_path = True,
                    order = deployed.createOrder - 1,
                    description = "Copy Resource Adapter '%s' to node '%s'" % (deployed.name, node.name)
                ))

for d in deltas.deltas:
    if d.operation in ["CREATE"]:
        deployed = d.deployed
        if deployed.type == "was.J2CResourceAdapter":
            context.addStepWithCheckpoint(steps.wsadmin(
                target_cell = deployed.container.cell,
                description = "Create J2C Resource Adapter '%s' on '%s'" % (deployed.name, deployed.container.name),
                order = deployed.createOrder,
                script = "was/resources/ra/create-j2c-resource-adapter.py",
                python_context = {"deployed": deployed,
                                  "nodePaths": nodePaths}
            ), d, Operation.CREATE)
