#
def getCoreGroupConfigArgs(deployed):
    args = toAdminConfigArgs(allNoneToEmpty(excludeUnsupportedProperties("CoreGroup", deployed.getExposedProperties(True))))
    if hasattr(deployed, "Liveness") and "liveness" in getConfigTypeAttrs("CoreGroup"):
        args.extend([["liveness", toAdminConfigArgs(allNoneToEmpty(excludeUnsupportedProperties("Liveness", deployed.Liveness.getExposedProperties(True))))]])
    return args

def returnOnlyRemovedServers(nodeName, serverName, clusterName):
    servers = deployed.coreGroupServers
    servers.extend([server for cluster in deployed.coreGroupClusters for server in cluster.servers])
    return len([server for server in servers if server.name == serverName and server.nodeName == nodeName]) == 0

def moveClustersToCoreGroup(deployed):
    for cluster in deployed.coreGroupClusters:
        if len(cluster.servers) == 0:
            print "Ignoring empty cluster '%s'" % (cluster.name)
        else:
            server = cluster.servers[0]
            currentCoreGroup = AdminTask.getCoreGroupNameForServer("[-nodeName %s -serverName %s]" % (server.nodeName, server.name))
            if currentCoreGroup == deployed.name:
                print "Cluster '%s' already assigned to Core Group '%s'" % (cluster.name, deployed.name)
            else:
                print "Moving cluster '%s' from Core Group '%s'" % (cluster.name, currentCoreGroup)
                AdminTask.moveClusterToCoreGroup("[-source %s -target %s -clusterName %s]" % (currentCoreGroup, deployed.name, cluster.name))

def moveServersToCoreGroup(deployed):
    for server in deployed.coreGroupServers:
        currentCoreGroup = AdminTask.getCoreGroupNameForServer("[-nodeName %s -serverName %s]" % (server.nodeName, server.name))
        if currentCoreGroup == deployed.name:
            print "Server '%s' already assigned to Core Group '%s'" % (server.name, deployed.name)
        else:
            print "Moving server '%s' from Core Group '%s'" % (server.name, currentCoreGroup)
            AdminTask.moveServerToCoreGroup("[-source %s -target %s -nodeName %s -serverName %s]" % (currentCoreGroup, deployed.name, server.nodeName, server.name))

def updatePreferredCoordinatorServers(deployed, coreGroupId):
    preferredCoordinatorServerIds = [getCoreGroupServer(deployed, server) for server in deployed.preferredCoordinatorServers]
    print "Assigning preferred coordinator servers '%s'" % (preferredCoordinatorServerIds)
    adminConfigModify(coreGroupId, [["preferredCoordinatorServers", []]])
    adminConfigModify(coreGroupId, [["preferredCoordinatorServers", preferredCoordinatorServerIds]])

def updatePolicies(deployed, coreGroupId):
    for policyId in wsadminToList(AdminConfig.showAttribute(coreGroupId, "policies")):
        print "Removing policy '%s'" % policyId
        AdminConfig.remove(policyId)
    if deployed.policies:
        for policy in deployed.policies:
            args = toAdminConfigArgs(allNoneToEmpty(excludeUnsupportedProperties(policy.wasType, policy.getExposedProperties(True))))
            print "Creating Policy '%s' for '%s' with args %s" % (policy.name, deployed.name, args)
            policyId = adminConfigCreate(policy.wasType, coreGroupId, args)
            # custom properties
            updateCustomProperties(policy, policyId)
            # match criteria
            if policy.matchCriteria:
                for name, value in policy.matchCriteria.items():
                    adminConfigCreate("MatchCriteria", policyId, [["name", name], ["value", value]])
            # servers
            serversProperty = None
            if hasattr(policy, "servers"):
                serversProperty = "servers"
            elif hasattr(policy, "preferredServers"):
                serversProperty = "preferredServers"
            if serversProperty:
                coreGroupServers = [getCoreGroupServer(deployed, server) for server in getattr(policy, serversProperty)]
                adminConfigModify(policyId, [[serversProperty, coreGroupServers]])

def updateCustomProperties(deployed, parentId):
    removeCustomProps(parentId, "customProperties")
    if hasattr(deployed, "customProperties"):
        createCustomProps(parentId, "Property", deployed)

def createOrModifyCoreGroup():
    containerId = validateNotEmpty(AdminConfig.getid(deployed.container.containmentPath), "Cannot locate containment path '%s'" % (deployed.container.containmentPath))
    args = getCoreGroupConfigArgs(deployed)
    coreGroupId = getCoreGroup(deployed, deployed.container)
    if not coreGroupId:
        print "Creating Core Group '%s' for '%s' with args %s" % (deployed.name, containerId, args)
        coreGroupId = adminConfigCreate('CoreGroup', containerId, args)
    else:
        print "Modifying Core Group '%s' for '%s' with args %s" % (deployed.name, containerId, args)
        adminConfigModify(coreGroupId, args)

    returnServersToDefaultGroup(deployed, coreGroupId, filterCallback=returnOnlyRemovedServers)
    moveClustersToCoreGroup(deployed)
    moveServersToCoreGroup(deployed)
    updatePreferredCoordinatorServers(deployed, coreGroupId)
    updatePolicies(deployed, coreGroupId)
    updateCustomProperties(deployed, coreGroupId)

createOrModifyCoreGroup()