#
def createConnectionFactory(props, provider, deployed):
    args = toAdminConfigArgs(excludeUnsupportedProperties(deployed, props))
    jmsProviderContainmentPath = '%s/JMSProvider:%s' % (deployed.container.containmentPath, provider)
    jmsProviderId = validateNotEmpty(AdminConfig.getid(jmsProviderContainmentPath), "Cannot locate WebSphere JMS Provider '%s' in container '%s'" % (provider, deployed.container.name))
    print "Creating '%s' for JMS provider '%s' with args '%s' in container '%s'" % (deployed.wasType, jmsProviderId, args, deployed.container.name)
    connectionFactoryId = adminConfigCreate(deployed.wasType, jmsProviderId, args)
    configureConnectionFactoryNestedObjects(connectionFactoryId, deployed)

def modifyConnectionFactory(props, provider, deployed):
    if 'providerType' in props.keys():
        print "Ignoring property 'providerType' which is a read-only attribute."
        del props['providerType']
    args = toAdminConfigArgs(excludeUnsupportedProperties(deployed, props))
    containmentPath = '%s/JMSProvider:%s/%s:%s' % (deployed.container.containmentPath, provider, deployed.wasType, deployed.name)
    providerId = validateNotEmpty(AdminConfig.getid(containmentPath), "Cannot locate containment path '%s'" % (containmentPath))
    print "Modifying '%s' for JMS provider '%s' with args '%s' in container '%s'" % (deployed.wasType, providerId, args, deployed.container.name)
    if getVersion(deployed.container) == 'WAS_61':
        unsetAttributes(providerId, props.keys())
        adminConfigModify(providerId, args)
    else:
        AdminConfig.unsetAttributes(providerId, props.keys())
        AdminConfig.resetAttributes(providerId, args)
    configureConnectionFactoryNestedObjects(providerId, deployed)

def configureConnectionFactoryNestedObjects(providerId, deployed):
    createOrModifyMappingModule(providerId, deployed)
    if hasattr(deployed, 'ConnectionPool'):
        poolArgs = toAdminConfigArgs(deployed.ConnectionPool.getExposedProperties())
        configureConnectionPool(providerId, poolArgs, 'connectionPool')
    if hasattr(deployed, 'SessionPool'):
        poolArgs = toAdminConfigArgs(deployed.SessionPool.getExposedProperties())
        configureConnectionPool(providerId, poolArgs, 'sessionPool')
    removeJ2EEResourceProperties(providerId)
    if hasattr(deployed, 'customProperties'):
        createJ2EEResourceProperties(providerId, deployed)

def createOrModifyMappingModule(providerId, deployed):
    mappingProps = {
        'authDataAlias': noneToEmpty(deployed.containerAuthDataAlias),
        'mappingConfigAlias': noneToEmpty(deployed.mappingConfigAlias)
    }
    if deployed.mappingConfigAlias == 'None':
        mappingProps['mappingConfigAlias'] = ''
    mappingArgs = toAdminConfigArgs(mappingProps)
    mapping = AdminConfig.showAttribute(providerId, 'mapping')
    if mapping:
        print "Modifying MappingModule with the args '%s'" % (mappingArgs)
        adminConfigModify(mapping, mappingArgs)
    else:
        print "Creating MappingModule with the args '%s'" % (mappingArgs)
        adminConfigCreate('MappingModule', providerId, mappingArgs)

def inspectJmsQueueConnectionFactories(deployedId, jmsName, jmsId, container, prototype):
    ignoredProps = getUnsupportedTypeAttrs(prototype.wasType, prototype.getExposedProperties(True).keys())
    ignoredProps.append('name')
    inspectDeployedProperties(deployedId, jmsName, jmsId, prototype, ignoredProps)
    discoverConnectionFactoryNestedObjects(deployedId, jmsId, 'ConnectionPool_', 'connectionPool')
    discoverConnectionFactoryNestedObjects(deployedId, jmsId, 'SessionPool_', 'sessionPool')
    discoverConnectionFactoryMappingObjects(deployedId, jmsId, 'mapping')
    inspectNestedJ2EEResourceProperties(deployedId, jmsId, "propertySet", "customProperties")

def discoverConnectionFactoryNestedObjects(deployedId, jmsId, nestedProperty, nestedAttribute):
    attributeId = AdminConfig.showAttribute(jmsId, nestedAttribute)
    attributes = AdminConfig.show(attributeId)
    attrMap = wsadminToDict(attributes)
    for key in attrMap.keys():
        inspectedProperty(deployedId, "%s%s"  % (nestedProperty, key), attrMap[key])

def discoverConnectionFactoryMappingObjects(deployedId, jmsId, mappingObject):
    attributeId = AdminConfig.showAttribute(jmsId, mappingObject)
    attributes = wsadminToDict(AdminConfig.show(attributeId))
    inspected = []
    for key in attributes.keys():
        if attributes[key] and attributes[key] != '[]':
            inspected.append(key)
            if key != "authDataAlias":
                inspectedProperty(deployedId, key, attributes[key])
            else:
                inspectedProperty(deployedId, 'containerAuthDataAlias', attributes[key])
    if 'mappingConfigAlias' not in inspected:
        inspectedProperty(deployedId, 'mappingConfigAlias', 'None')