/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.python.DerivedProperty;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.Node;
import com.xebialabs.deployit.plugin.was.container.NodeAgent;
import com.xebialabs.deployit.plugin.was.container.Webserver;
import com.xebialabs.deployit.plugin.was.container.WebserverType;
import com.xebialabs.deployit.plugin.was.deployable.ManagedWebServerSpec;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedContainer;
import com.xebialabs.deployit.plugin.was.step.ManagedWebServerPluginConfigurationCopyStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(description="A WebSphere Web server managed by a node that is part of a deployment manager (WAS ND)")
public class ManagedWebServer
extends ExtensibleDeployedContainer<ManagedWebServerSpec, Node>
implements Webserver {
    @Property(required=true, defaultValue="IHS", description="Specifies the name of the template that you want to use. Templates include the following: IHS, iPlanet, IIS, DOMINO, APACHE. The default template is IHS.")
    private WebserverType webserverType;

    @DerivedProperty(value="node")
    public Node getNode() {
        return (Node)this.getContainer();
    }

    public void setNode(NodeAgent node) {
        this.setContainer((Container)node);
    }

    @Override
    public Cell getCell() {
        Preconditions.checkNotNull((Object)this.getNode(), (String)"%s has null node", (Object)this);
        return this.getNode().getCell();
    }

    public PythonManagingContainer getManagingContainer() {
        return this.getCell();
    }

    @Override
    public String getCellName() {
        Preconditions.checkNotNull((Object)this.getCell(), (String)"%s has null cell", (Object)this);
        return this.getCell().getName();
    }

    @DerivedProperty(value="nodeName")
    public String getNodeName() {
        Preconditions.checkNotNull((Object)this.getNode(), (String)"%s has null node", (Object)this);
        return this.getNode().getName();
    }

    public Set<Node> getNodes() {
        return Collections.singleton(this.getNode());
    }

    @Override
    public WebserverType getWebserverType() {
        return this.webserverType;
    }

    @Override
    public void setWebserverType(WebserverType webserverType) {
        this.webserverType = webserverType;
    }

    @Override
    public String getContainmentPath() {
        return "/Node:" + this.getNodeName() + "/Server:" + this.getName();
    }

    @Override
    public String getWasConfigIdType() {
        return "Server";
    }

    @Override
    public String getWasTargetType() {
        return "server";
    }

    @Override
    public String getShortTypeDescription() {
        return "managed webserver";
    }

    public Host getHost() {
        return this.getNode().getHost();
    }

    public List<Step> controlTaskDispatch(String name, Map<String, String> args) {
        return ControlTaskDelegate.dispatch((String)name, args, (ConfigurationItem)this, (Container)this);
    }

    @ControlTask(label="Propagate Plugin", description="Distributes the webserver plugin.")
    public List<Step> propagatePlugin() {
        Integer propagatePluginOrder = (Integer)this.getProperty("propagatePluginOrder");
        if (this.getProperty("host") != null) {
            ManagedWebServerPluginConfigurationCopyStep prop = new ManagedWebServerPluginConfigurationCopyStep(propagatePluginOrder, this);
            ArrayList stepsList = Lists.newArrayList((Object[])new Step[]{prop});
            return stepsList;
        }
        PythonDeploymentStep prop = new PythonDeploymentStep(propagatePluginOrder.intValue(), (PythonManagingContainer)this.getNode().getCell(), (String)this.getProperty("propagatePluginScript"), (Map)ImmutableMap.of((Object)"container", (Object)this), String.format("Propagate web server plugin configuration to web server '%s'", this.getName()));
        ArrayList stepsList = Lists.newArrayList((Object[])new Step[]{prop});
        return stepsList;
    }

    @Override
    public List<String> getApplicationManagerObjectNames() {
        Preconditions.checkNotNull((Object)this.getNode(), (String)"%s has null node", (Object)this);
        Preconditions.checkNotNull((Object)this.getCell(), (String)"%s has null cell", (Object)this);
        String applicationManagerObjectName = "cell=" + this.getCellName() + ",node=" + this.getNodeName() + ",type=ApplicationManager,process=" + this.getName() + ",*";
        return Collections.singletonList(applicationManagerObjectName);
    }
}

