/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.python.DerivedProperty;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.Node;
import com.xebialabs.deployit.plugin.was.container.NodeAgent;
import com.xebialabs.deployit.plugin.was.container.Server;
import com.xebialabs.deployit.plugin.was.container.ServerType;
import com.xebialabs.deployit.plugin.was.deployable.ManagedServerSpec;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedContainer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(description="A WebSphere server managed by a node that is part of a deployment manager (WAS ND)")
public class ManagedServer
extends ExtensibleDeployedContainer<ManagedServerSpec, NodeAgent>
implements Server {
    @Property(required=false, hidden=false, label="Server type", description="Server type. Possible values are: PROXY_SERVER, APPLICATION_SERVER, ONDEMAND_ROUTER")
    private ServerType serverType;

    @DerivedProperty(value="node")
    public NodeAgent getNode() {
        return (NodeAgent)this.getContainer();
    }

    public void setNode(NodeAgent node) {
        this.setContainer((Container)node);
    }

    @Override
    public Cell getCell() {
        Preconditions.checkNotNull((Object)this.getNode(), (String)"%s has null node", (Object)this);
        return this.getNode().getCell();
    }

    public PythonManagingContainer getManagingContainer() {
        return this.getCell();
    }

    @Override
    public String getCellName() {
        Preconditions.checkNotNull((Object)this.getCell(), (String)"%s has null cell", (Object)this);
        return this.getCell().getName();
    }

    @DerivedProperty(value="nodeName")
    public String getNodeName() {
        Preconditions.checkNotNull((Object)this.getNode(), (String)"%s has null node", (Object)this);
        return this.getNode().getName();
    }

    public Set<Node> getNodes() {
        return Collections.singleton(this.getNode());
    }

    @Override
    public ServerType getServerType() {
        return this.serverType;
    }

    @Override
    public void setServerType(ServerType serverType) {
        this.serverType = serverType;
    }

    @Override
    public String getContainmentPath() {
        return "/Node:" + this.getNodeName() + "/Server:" + this.getName();
    }

    @Override
    public String getWasConfigIdType() {
        return "Server";
    }

    @Override
    public String getWasTargetType() {
        return "server";
    }

    @Override
    public String getShortTypeDescription() {
        return "managed server";
    }

    public Host getHost() {
        return this.getNode().getHost();
    }

    public List<Step> controlTaskDispatch(String name, Map<String, String> args) {
        return ControlTaskDelegate.dispatch((String)name, args, (ConfigurationItem)this, (Container)this);
    }

    @Override
    public List<String> getApplicationManagerObjectNames() {
        Preconditions.checkNotNull((Object)this.getNode(), (String)"%s has null node", (Object)this);
        Preconditions.checkNotNull((Object)this.getCell(), (String)"%s has null cell", (Object)this);
        String applicationManagerObjectName = "cell=" + this.getCellName() + ",node=" + this.getNodeName() + ",type=ApplicationManager,process=" + this.getName() + ",*";
        return Collections.singletonList(applicationManagerObjectName);
    }
}

