#
def inspectCoreGroupServers(deployedId, container, coreGroupId, propertyName, includeClusters=False):
    for coreGroupServerId in wsadminToList(AdminConfig.showAttribute(coreGroupId, propertyName)):
        nodeName = AdminConfig.showAttribute(coreGroupServerId, "nodeName")
        serverName = AdminConfig.showAttribute(coreGroupServerId, "serverName")
        serverId = getServerId(nodeName, serverName)
        serverType = AdminConfig.showAttribute(serverId, "serverType")
        clusterName = AdminConfig.showAttribute(serverId, "clusterName")

        if serverType != "NODE_AGENT" and serverType != "DEPLOYMENT_MANAGER":
            inspectedProperty(deployedId, propertyName, ["%s/%s/%s" % (container.id, nodeName, serverName)])

        if includeClusters and clusterName and serverType != "ONDEMAND_ROUTER":
            inspectedProperty(deployedId, "coreGroupClusters", ["%s/%s" % (container.id, clusterName)])

def discoverAndInspectPolicies(container, deployedId, coreGroupId):
    for policyId in wsadminToList(AdminConfig.showAttribute(coreGroupId, "policies")):
        policyName = AdminConfig.showAttribute(policyId, "name")
        policyType = getObjectType(container, policyId)
        policyDeployedId = "%s/%s" % (deployedId, policyName)
        if appendTypeToName:
            policyDeployedId = policyDeployedId + '_was.%s' % policyType

        discovered(policyDeployedId, "was.%s" % policyType)
        inspectedProperty(policyDeployedId, 'wasName', policyName)

        for name, value in wsadminToDict(AdminConfig.show(policyId)).items():
            if name == "MatchCriteria":
                for matchCriteriaId in value:
                    inspectedProperty(policyDeployedId, "matchCriteria",
                                      {AdminConfig.showAttribute(matchCriteriaId, "name"): AdminConfig.showAttribute(matchCriteriaId, "value")})
            elif name == "customProperties":
                inspectCustomProperties(policyDeployedId, value, "customProperties")
            elif name == "servers" or name == "preferredServers":
                inspectCoreGroupServers(policyDeployedId, container, policyId, name)
            else:
                inspectedProperty(policyDeployedId, name, value)

        inspectedItem(policyDeployedId)

def inspectLiveness(deployedId, coreGroupId):
    if "liveness" in getConfigTypeAttrs("CoreGroup"):
        livenessId = AdminConfig.showAttribute(coreGroupId, "liveness")
        for name, value in wsadminToDict(AdminConfig.show(livenessId)).items():
            inspectedProperty(deployedId, "Liveness_%s" % name, value)

def discoverAndInspectCoreGroups(container):
    for coreGroupId in wsadminToList(AdminConfig.getid("%s/CoreGroup:/" % container.containmentPath)):
        deployedName = AdminConfig.showAttribute(coreGroupId, "name")
        if appendTypeToName:
            deployedId = container.id + '/' + deployedName + '_' + prototype.type
        else:
            deployedId = container.id + '/' + deployedName
        discovered(deployedId, prototype.type)
        inspectedProperty(deployedId, 'wasName', deployedName)
        ignoredProps = getUnsupportedTypeAttrs("CoreGroup", prototype.getExposedProperties(True).keys(), False)
        ignoredProps.append('name')
        inspectDeployedProperties(deployedId, deployedName, coreGroupId, prototype, ignoredProps)
        inspectCoreGroupServers(deployedId, container, coreGroupId, "coreGroupServers", includeClusters=True)
        inspectCoreGroupServers(deployedId, container, coreGroupId, "preferredCoordinatorServers")
        inspectCustomProperties(deployedId, wsadminToList(AdminConfig.showAttribute(coreGroupId, "customProperties")), "customProperties")
        inspectLiveness(deployedId, coreGroupId)
        discoverAndInspectPolicies(container, deployedId, coreGroupId)
        inspectedItem(deployedId)

for c in findAllContainers(container):
    discoverAndInspectCoreGroups(c)
