package com.xebialabs.deployit.plugin.was.validator;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;

/**
 * This rule enables you to restrict a collection property to contain only zero or one elements.
 *
 * Type = exclusive-property
 *
 * Attributes: message: override the default error message
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = SingletonCollection.Validator.class, type = "was-singleton-collection")
@ApplicableTo({ PropertyKind.SET_OF_CI, PropertyKind.SET_OF_STRING, PropertyKind.LIST_OF_CI, PropertyKind.LIST_OF_STRING, PropertyKind.MAP_STRING_STRING })
@Target(ElementType.FIELD)
public @interface SingletonCollection {
    String DEFAULT_MESSAGE = "The collection property can not contain more than 1 item, found: %s";

    String message() default DEFAULT_MESSAGE;

    public static class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<Object> {
        private String message = DEFAULT_MESSAGE;

        @Override
        public void validate(Object value, ValidationContext context) {

            // Cast is safe because the rule is only applicable to collections
            int size = ((Collection<?>) value).size();
            if (!(size == 1 || size == 0)) {
                context.error(message, size);
            }
        }
    }
}
