def j2cResourceAdapterProps(deployed):
    return excludeUnsupportedProperties(deployed, deployed.getExposedProperties(True))

def getGeneratedCustomProperties(deployed):
    raTemplateId = AdminConfig.getid("/Node:%s/J2CResourceAdapter:%s" % (getNodeNames(deployed)[0], deployed.name))
    if raTemplateId:
        propertySetId = AdminConfig.showAttribute(raTemplateId, 'propertySet')
        if propertySetId:
            properties = {}
            for pid in wsadminToList(AdminConfig.showAttribute(propertySetId, "resourceProperties")):
                name = AdminConfig.showAttribute(pid, "name")
                value = AdminConfig.showAttribute(pid, "value")
                if not value:
                    value = ''
                properties[name] = value
            return properties

def setJ2CResourceAdapterProperties(raId, deployed, props):
    if getVersion(deployed.container) != 'WAS_61':
        AdminConfig.unsetAttributes(raId, props.keys())
    else:
        unsetAttributes(raId, props.keys())
    adminConfigModify(raId, toAdminConfigArgs(props))

def getNodeNames(deployed):
    return [name.strip() for name in deployed.nodeName.split(',')]

def getNodePaths(paths):
    nodePaths = {}
    lines = paths.splitlines()
    for line in lines:
        nodeName, nodePath = line.split('=')
        nodePaths[nodeName] = nodePath
    return nodePaths

def findNodes(container):
    nodes = []
    if container.type in ["was.DeploymentManager"]:
        for node in container.nodeAgents:
            nodes.append(node)
    elif container.type in ["was.NodeAgent"]:
        nodes.append(container)
    elif container.type in ["was.Cluster", "was.DynamicCluster"]:
        for server in container.servers:
            nodes.append(server.node)
    elif container.type in ["was.ManagedServer"]:
        nodes.append(container.node)
    return nodes

################################################################################################################
# Create, modify, destroy, inspect functions
################################################################################################################
def createJ2CResourceAdapter(deployed, props, paths):
    args = toAdminConfigArgs(props)
    print "Creating %s with args '%s' in container '%s'" % (deployed.wasType, args, deployed.container.name)

    nodePaths = getNodePaths(paths)
    for node in findNodes(deployed.container):
        rarKey = "%s/%s" % (node.name, deployed.name)
        nodePath = nodePaths[rarKey]
        raTemplateId = AdminConfig.getid("/Node:%s/J2CResourceAdapter:%s" % (node.name, deployed.name))
        if raTemplateId:
            print "J2C resource adapter '%s' already installed on node '%s'. Reusing the existing RAR." % (deployed.name, node.name)
        else:
            options = {"rar.name": deployed.name, "nodeName": node.name, "rarPath": nodePath}
            raTemplateId = AdminTask.installResourceAdapter(toAdminTaskArgs(options))

    if deployed.container.type not in ["was.NodeAgent"]:
        if wsadminToList(AdminConfig.getid('%s/J2CResourceAdapter:%s' % (deployed.container.containmentPath, deployed.name))):
            printErrorAndExit("ERROR: J2C resource adapter '%s' already installed on container '%s'" % (deployed.name, deployed.container.name))
        scopeId = validateNotEmpty(AdminConfig.getid(deployed.container.containmentPath), "Cannot locate container '%s'" % (deployed.container.name))
        raId = AdminTask.copyResourceAdapter(raTemplateId, ["-name", deployed.name, "-scope", scopeId])
    else:
        raId = raTemplateId

    setJ2CResourceAdapterProperties(raId, deployed, props)
    createOrUpdateJ2EEResourceProperties(raId, deployed)

def modifyJ2CResourceAdapter(deployed, props):
    args = toAdminConfigArgs(props)
    raId = getJ2CResourceAdapter(deployed)
    print "Modify %s with args '%s' in container '%s'" % (deployed.wasType, args, deployed.container.name)

    setJ2CResourceAdapterProperties(raId, deployed, props)
    if deployed.customProperties:
        generatedProperties = getGeneratedCustomProperties(deployed)
        if generatedProperties:
            print "Reset custom properties to default generated values"
            removeJ2EEResourceProperties(raId)
            generatedProperties.update(deployed.customProperties)
            deployed.customProperties = generatedProperties
        createOrUpdateJ2EEResourceProperties(raId, deployed)

def destroyJ2CResourceAdapter(deployed):
    id = getJ2CResourceAdapter(deployed)
    print "Destroying %s '%s' in container '%s'" % (deployed.wasType, deployed.name, deployed.container.name)
    AdminConfig.remove(id)

def inspectJ2CResourceAdapter(deployedId, deployedName, resourceId, prototype):
    ignoredProps = getUnsupportedTypeAttrs(prototype.wasType, prototype.getExposedProperties(True).keys())
    ignoredProps.append("name")
    inspectDeployedProperties(deployedId, deployedName, resourceId, prototype, ignoredProps)

    nodeNames = []
    for nodeId in wsadminToList(AdminConfig.getid("/Node:/")):
        nodeName = AdminConfig.showAttribute(nodeId, "name")
        if deployedName in [AdminConfig.showAttribute(raId, "name") for raId in wsadminToList(AdminConfig.getid("/Node:%s/J2CResourceAdapter:/" % nodeName))]:
            nodeNames.append(nodeName)
    if nodeNames:
        inspectedProperty(deployedId, "nodeName", ",".join(nodeNames))
    inspectNestedJ2EEResourceProperties(deployedId, resourceId, "propertySet", "customProperties")

