import re

def reverseMap(map):
    reverse = {}
    for k, v in map.items():
        reverse[v] = k
    return reverse

wasToTimeUnitsMap = {
    "0":"MILLISECONDS",
    "1":"SECONDS",
    "2":"MINUTES",
    "3":"HOURS"
}
timeUnitsToWasMap = reverseMap(wasToTimeUnitsMap)

wasToReactionModeMap = {
    "3":"AUTOMATIC",
    "2":"SUPERVISE"
}
reactionModeToWasMap = reverseMap(wasToReactionModeMap)

ageUnitsList = ["ageUnits"]
wasToAgeUnitsMap = {
    "3": "HOURS",
    "4": "DAYS",
}
ageUnitsToWasMap = reverseMap(wasToAgeUnitsMap)

actionTypeMap = {
    "HEAPDUMP": "was.HealthActionHeapDump",
    "THREADDUMP": "was.HealthActionThreadDump",
    "RESTART": "was.HealthActionRestartServer",
    "SETMAINTENANCEMODE":"was.HealthActionSetMaintenanceMode",
    "SETMAINTENANCEMODE_BREAK":"was.HealthActionSetMaintenanceModeBreakAffinity",
    "SETMAINTENANCEMODE_STOP":"was.HealthActionSetMaintenanceModeStop",
    "UNSETMAINTENANCEMODE":"was.HealthActionUnsetMaintenanceMode",
    "SENDSNMPTRAP": "was.HealthActionSendSnmpTrap"
}

conditionTypeToWasMap = {
    'AGE': 'AgeCondition',
    'STORM_DRAIN': 'StormDrainCondition',
    'EXCESSIVE_MEMORY': 'MemoryCondition',
    'WORKLOAD': 'WorkloadCondition',
    'EXCESSIVE_REQUEST_TIMEOUT': 'StuckRequestCondition',
    'MEMORY_LEAK': 'MemoryLeakAlgorithm',
    'EXCESSIVE_RESPONSE_TIME': 'ResponseCondition',
    'GC_PERCENTAGE': 'GCPercentageCondition'
}

wasToConditionTypeMap = {
    'AgeCondition': 'was.HealthConditionAge',
    'StormDrainCondition': 'was.HealthConditionStormDrain',
    'MemoryCondition': 'was.HealthConditionExcessiveMemory',
    'WorkloadCondition': 'was.HealthConditionWorkload',
    'StuckRequestCondition': 'was.HealthConditionExcessiveRequestTimeout',
    'MemoryLeakAlgorithm': 'was.HealthConditionMemoryLeak',
    'ResponseCondition': 'was.HealthConditionExcessiveResponseTime',
    'GCPercentageCondition': 'was.HealthConditionGarbageCollectionPercentage'
}

containerTypeMap = {
    'Cell': 'CELL',
    'DynamicCluster': 'DYNAMIC_CLUSTER',
    'ServerCluster': 'CLUSTER',
    'Server': 'SERVER',
    'DynamicOdrCluster': 'ODR'
}

wasToContainerTypeMap = {
    '1': 'Server',
    '2': 'ServerCluster',
    '3': 'DynamicCluster',
    '4': 'Cell',
    '5': 'DynamicOdrCluster'
}

numberToUnitsList = ["timeUnits", "responseTimeUnits", "samplingUnits"]

def toEnclosedArgString(properties, startChar, endChar):
    argString = ""
    for propName, propValue in properties.items():
        if propValue != None:
            if isinstance(propValue, DictionaryObject):
                argString += "%s'%s' '%s'%s" % (startChar, propName, str(propValue.name), endChar)
            else:
                argString += "%s'%s' '%s'%s" % (startChar, propName, str(propValue), endChar)
    return "%s%s%s" % (startChar, argString, endChar)

def checkHealthCondition(deployed):
    if (not hasattr(deployed, 'condition') or not deployed.condition) and len(deployed.condition) != 1:
        printErrorAndExit("ERROR: '%s' must have exactly one health condition" % (deployed.name))

def findHealthPolicy(name):
    hpList = wsadminToList(AdminTask.listHealthPolicies())
    hpList = [hp for hp in hpList if AdminConfig.showAttribute(hp, 'name') == name]

    if not hpList:
        return None
    else:
        return hpList[0]

def  findHealthActionIds(healthPolicy):
    return re.findall('\([^\|]+\|healthclass\.xml#HealthAction_\d+\)', AdminConfig.showAttribute(healthPolicy, "healthActions"))

# Health actions use AdminConfig in stead of the AdminTask API due to things missing there.
def findHealthActions(healthPolicy):
    """ Return map with key step number to action """
    actionMap = {}
    for action in findHealthActionIds(healthPolicy):
        print "Action = ", action
        stepNum = AdminConfig.showAttribute(action, 'stepNum')
        actionType = AdminConfig.showAttribute(action, 'actionType')
        if actionMap.has_key(stepNum):
            print "WARNING: multiple health actions with stepNum '%s' in healthPolicy '%s'" % (stepNum, AdminConfig.showAttribute(healthPolicy, 'name'))
        actionMap[stepNum] = actionType
        print "Discovered action #%s of type '%s'" % (stepNum, actionType)
    return actionMap

def createHealthActions(healthPolicyName, healthActions):
    healthPolicyId = AdminConfig.getid('/HealthClass:'+healthPolicyName+'/')
    stepNum = 1
    for action in healthActions:
        actionArgs = [['actionType', action.actionType], ['stepNum', stepNum]]
        print "Creating health action #%d '%s' for Health Policy '%s'" %(stepNum, action.actionType, healthPolicyName)
        adminConfigCreate('HealthAction', healthPolicyId, actionArgs, 'healthActions')
        stepNum += 1

def deleteHealthActions(healthPolicy):
    for id in findHealthActionIds(healthPolicy):
        AdminConfig.remove(id)

def getConditionArguments(condition):
    conditionProperties = condition.getExposedProperties(True)

    if conditionProperties.has_key('ageUnits'):
        conditionProperties['ageUnits'] = ageUnitsToWasMap[conditionProperties['ageUnits']]
    if conditionProperties.has_key('responseTimeUnits'):
        conditionProperties['responseTimeUnits'] = timeUnitsToWasMap[conditionProperties['responseTimeUnits']]
    if conditionProperties.has_key('timeUnits'):
        conditionProperties['timeUnits'] = timeUnitsToWasMap[conditionProperties['timeUnits']]
    if conditionProperties.has_key('samplingUnits'):
        conditionProperties['samplingUnits'] = timeUnitsToWasMap[conditionProperties['samplingUnits']]

    return toEnclosedArgString(conditionProperties, '[', ']')

def deleteHealthCondition(healthPolicy):
    conditionId = AdminConfig.showAttribute(healthPolicy, "HealthCondition")
    print "Removing health condition ", conditionId
    AdminConfig.remove(conditionId)

def createHealthCondition(healthPolicy, condition):
    conditionArgs = getConditionArguments(condition)
    conditionType = conditionTypeToWasMap[condition.conditionType]
    print "Create %s with %s" % (conditionType, conditionArgs)
    adminConfigCreate(conditionType, healthPolicy, conditionArgs, 'HealthCondition')

def getMembershipArguments(healthPolicyName, container):
    args = ['-name', healthPolicyName]

    if not containerTypeMap.has_key(container.wasConfigIdType):
        printErrorAndExit("Unsupported container '%s'" % container.wasConfigIdType)

    memberArgs = '%s "%s"' % (containerTypeMap[container.wasConfigIdType], container.name)
    # TODO: Might also need this for ODR?
    if container.wasConfigIdType == 'Server':
        memberArgs += ' "%s"' % (container.nodeName)

    args.extend(['-addMember', '[[%s]]' % memberArgs])

    return args

def  findTargetMembershipIds(healthPolicy):
    return re.findall('\([^\|]+\|healthclass\.xml#TargetMembership_\d+\)', AdminConfig.showAttribute(healthPolicy, "targetMemberships"))

def deleteMembership(healthPolicy, member):
    # not using -removeMember since it doesn't work for servers
    id = member.name
    if member.wasConfigIdType in ('Server', 'UnmanagedServer'):
        id = "%s:!:%s" % (member.name, member.nodeName)

    for mid in findTargetMembershipIds(healthPolicy):
        ms = AdminConfig.showAttribute(mid, "memberString")
        if ms == id:
            AdminConfig.remove(mid)
            return
    print "'%s' not found in health policy '%s' nothing to do." % (member.name, AdminConfig.showAttribute(healtPolicy, 'name'))
