########################################################################################################################
#
# Function to discover and inspect datasources in all scopes.
#
# canHandleDatasourceTypeCallback : if the caller can handle the specific datasource. The callback is called for each
#                                   resource property on the datasource so that the function can figure out whether
#                                   it can handle the inspection of the datsource.
#     datasourceId - WAS id of the datasourceId
#     resourcePropertyName - resource property name
#     resourcePropertyId - WAS id of the resource property
#     container - Deployit container on which the datasource resides.
#
# dsInspectCallback : the inspection function that should be used. Default is the inspectDatasource function in this lib.
#     deployedId - id of discovered ci.
#     dsName - name of the datasource
#     dsId - WAS id for the datasource
#     container - Deployit container on which the datasource resides.
#
########################################################################################################################

def inspectCustomProperties(deployedId, nestedPropId, deployitProperty, prototype):
    customProperties = {}
    if nestedPropId:
        for propsetItem in nestedPropId:
            name = AdminConfig.showAttribute(propsetItem, "name")
            if name not in prototype.getExposedPropertyNames():
                customProperties[name] = AdminConfig.showAttribute(propsetItem, "value")
        if len(customProperties) > 0:
            inspectedProperty(deployedId, deployitProperty, customProperties)

def discoverAndInspectDatasources(canHandleDatasourceTypeCallback, dsInspectCallback = None):
    if dsInspectCallback is None:
        dsInspectCallback = inspectDatasource
    for c in findAllContainers(container):
        discoverAndInspectDatasourcesInContainer(c, canHandleDatasourceTypeCallback, dsInspectCallback)

def discoverAndInspectDatasourcesInContainer(container, canHandleDatasourceTypeCallback, dsInspectCallback):
    print "Retrieving list of JDBC DataSources in container %s" % (container.name)
    datasources = wsadminToList(AdminConfig.getid('%s/JDBCProvider:/DataSource:/' % (container.containmentPath)))
    for ds in datasources:
        dName = AdminConfig.showAttribute(ds, 'name')
        propertySet = AdminConfig.showAttribute(ds, 'propertySet')
        resourceProperties = wsadminToList(AdminConfig.showAttribute(propertySet, 'resourceProperties'))
        for resourceProperty in resourceProperties:
            pName = AdminConfig.showAttribute(resourceProperty, 'name')
            if canHandleDatasourceTypeCallback(ds, pName, resourceProperty, container):
                print "Discovered %s %s in container %s" % (prototype.type, dName, container.name)
                if appendTypeToName:
                    deployedId = container.id + '/' + dName + '_' + prototype.type
                else:
                    deployedId = container.id + '/' + dName
                discovered(deployedId, prototype.type)
                inspectedProperty(deployedId, 'wasName', dName)
                dsInspectCallback(deployedId, dName, ds, container)
                inspectedItem(deployedId)
                break

def inspectDatasource(deployedId, dsName, datasourceId, container):
    for prop in ['jndiName', 'description', 'datasourceHelperClassname']:
        inspectedProperty(deployedId, prop, AdminConfig.showAttribute(datasourceId, prop))
    inspectedProperty(deployedId, 'jdbcProvider', AdminConfig.showAttribute(AdminConfig.showAttribute(datasourceId, 'provider'), 'name'))

    propertySet = AdminConfig.showAttribute(datasourceId, 'propertySet')
    resourceProperties = wsadminToList(AdminConfig.showAttribute(propertySet, 'resourceProperties'))
    for resourceProperty in resourceProperties:
        name = AdminConfig.showAttribute(resourceProperty, 'name')
        if name != 'name' and name in prototype.getExposedPropertyNames():
            inspectedProperty(deployedId, name, AdminConfig.showAttribute(resourceProperty, 'value'))
    inspectCustomProperties(deployedId, resourceProperties, "customProperties", prototype)

    jaasName = AdminConfig.showAttribute(datasourceId, 'authDataAlias')
    generatedAliasName = generateDefaultAliasName(dsName, container)
    if jaasName == generatedAliasName:
        authDataId = findJaasAuthenticationData(jaasName, container.cellName)
        if authDataId:
            inspectedProperty(deployedId, 'username', AdminConfig.showAttribute(authDataId, 'userId'))
            inspectedProperty(deployedId, 'password', AdminConfig.showAttribute(authDataId, 'password'))
        else:
            print "Data source '%s' refers to non existing JAAS Authentication Data '%s'" % (dsName, jaasName)
    else:
        inspectedProperty(deployedId, 'jaasAliasName', jaasName)

    connectionPool = AdminConfig.showAttribute(datasourceId, 'connectionPool')
    for prop in ['connectionTimeout', 'maxConnections', 'minConnections', 'reapTime', 'unusedTimeout', 'agedTimeout', 'purgePolicy']:
        inspectedProperty(deployedId, 'ConnectionPool_%s' % prop, AdminConfig.showAttribute(connectionPool, prop))

    xaRecoveryAuthAlias = AdminConfig.showAttribute(datasourceId, 'xaRecoveryAuthAlias')
    if xaRecoveryAuthAlias:
        if xaRecoveryAuthAlias == generatedAliasName:
            inspectedProperty(deployedId, 'useJaasAliasForXaRecovery', 'true')
        else:
            inspectedProperty(deployedId, 'useJaasAliasForXaRecovery', 'false')
            print "XA Recovery authentication alias set to '%s' ignoring." % xaRecoveryAuthAlias
    else:
        inspectedProperty(deployedId, 'useJaasAliasForXaRecovery', 'false')

    mappingId = AdminConfig.showAttribute(datasourceId, 'mapping')
    if mappingId:
        mappingConfigAlias = AdminConfig.showAttribute(mappingId, 'mappingConfigAlias')
        if mappingConfigAlias:
            inspectedProperty(deployedId, 'mappingConfigAlias', mappingConfigAlias)
        authDataAlias = AdminConfig.showAttribute(mappingId, 'authDataAlias')
        if authDataAlias == generatedAliasName:
            inspectedProperty(deployedId, 'useJaasAliasForContainerManagedAuthentication', 'true')
        else:
            print "Container-managed authentication alias set to '%s' ignoring." % authDataAlias
            inspectedProperty(deployedId, 'useJaasAliasForContainerManagedAuthentication', 'false')
    else:
        inspectedProperty(deployedId, 'mappingConfigAlias', None)
        inspectedProperty(deployedId, 'useJaasAliasForContainerManagedAuthentication', 'false')

    cmpCfList = wsadminToList(AdminConfig.list('CMPConnectorFactory', AdminConfig.getid(container.containmentPath)))
    cmpCf = [cmp for cmp in cmpCfList if AdminConfig.showAttribute(cmp, 'name') == "%s_CF" % dsName]
    if cmpCf:
        inspectedProperty(deployedId, 'containerManagedPersistence', 'true')
    else:
        inspectedProperty(deployedId, 'containerManagedPersistence', 'false')
