#
def isDiscoverableType(type):
    return type in ["HTTPInboundChannel"]

def getChannelType(transportChannelId):
    return getObjectType(container, transportChannelId)

################################################################################################################
# Discover and inspect functions
################################################################################################################
def discoverInspectTransportChains(container, channelServiceId):
    for transportChainId in  wsadminToList(AdminConfig.list("Chain", channelServiceId)):
        name = AdminConfig.showAttribute(transportChainId, "name")
        print "Discovered transport chain '%s' in container '%s'" % (name, container.name)
        if appendTypeToName:
            chainDeployedId = container.id + '/' + name + '_' + prototype.type
        else:
            chainDeployedId = container.id + '/' + name
        discovered(chainDeployedId, "was.TransportChain")
        inspectedProperty(chainDeployedId, 'wasName', name)
        inspectedProperty(chainDeployedId, "enable", AdminConfig.showAttribute(transportChainId, "enable"))
        for transportChannelId in wsadminToList(AdminConfig.showAttribute(transportChainId, "transportChannels")):
            discoverInspectTransportChannel(container, transportChannelId, name, chainDeployedId)
            if getChannelType(transportChannelId) == "TCPInboundChannel":
                portName = AdminConfig.showAttribute(transportChannelId, "endPointName")
                inspectedProperty(chainDeployedId, "portName", portName)
        inspectedItem(chainDeployedId)

def discoverInspectTransportChannel(container, transportChannelId, chainName, chainDeployedId):
        type = getChannelType(transportChannelId)
        if not isDiscoverableType(type): return
        name = AdminConfig.showAttribute(transportChannelId, "name")
        print "Discovered %s '%s' in chain '%s'" % (type, name, chainName)
        if appendTypeToName:
            channelDeployedId =  chainDeployedId + '/' + name + "_was." + type
        else:
            channelDeployedId =  chainDeployedId + '/' + name
        discovered(channelDeployedId, "was.%s" % type)
        inspectedProperty(channelDeployedId, 'wasName', name)
        inspectTransportChannel(container, type, channelDeployedId, transportChannelId)
        inspectCustomProperties(channelDeployedId, wsadminToList(AdminConfig.showAttribute(transportChannelId, "properties")), "customProperties")
        inspectedItem(channelDeployedId)

def inspectTransportChannel(container, type, channelDeployedId, transportChannelId):
    inspectHTTPInboundChannel(container, type, channelDeployedId, transportChannelId)

def inspectHTTPInboundChannel(container, type, channelDeployedId, transportChannelId):
    if type != "HTTPInboundChannel": return
    inspectConfigResource(channelDeployedId, transportChannelId)
    if getVersion(container) != 'WAS_61':
        loggingId = AdminConfig.showAttribute(transportChannelId, "httpInboundChannelLogging")
        if loggingId:
            inspectConfigResource(channelDeployedId, loggingId, "HttpInboundChannelLogging_")
            inspectConfigResource(channelDeployedId, AdminConfig.showAttribute(loggingId, "errorLog"), "HttpInboundChannelLogging_ErrorLog_")
            inspectConfigResource(channelDeployedId, AdminConfig.showAttribute(loggingId, "accessLog"), "HttpInboundChannelLogging_AccessLog_")
            inspectConfigResource(channelDeployedId, AdminConfig.showAttribute(loggingId, "frcaLog"), "HttpInboundChannelLogging_FrcaLog_")

################################################################################################################
# Entry point
################################################################################################################
for c in findAllContainers(container,onlyWasAppContainer=True):
    if c.wasConfigIdType == 'Server':
        channelServiceIds = wsadminToList(AdminConfig.list("TransportChannelService", AdminConfig.getid(c.containmentPath)))
        for channelServiceId in channelServiceIds:
            discoverInspectTransportChains(c, channelServiceId)