def discoverAndInspectResourceEnvProvider(container):
    resourceEnvProviderContainmentPath = '%s/ResourceEnvironmentProvider:/' % (container.containmentPath)
    try:
        resourceEnvProviders = validateNotEmpty(wsadminToList(AdminConfig.getid(resourceEnvProviderContainmentPath)), "Cannot locate Resource Environment Provider ContainmentPath '%s'" % (resourceEnvProviderContainmentPath))
        for resourceEnvProviderId in resourceEnvProviders :
            deployedName = AdminConfig.showAttribute(resourceEnvProviderId, 'name')
            if appendTypeToName:
                deployedId = container.id + '/' + deployedName + '_' + prototype.type
            else:
                deployedId = container.id + '/' + deployedName
            discovered(deployedId, prototype.type)
            inspectedProperty(deployedId, 'wasName', deployedName)
            inspectDeployedProperties(deployedId, deployedName, resourceEnvProviderId, prototype)
            inspectNestedResourceproperties(deployedId, resourceEnvProviderId, "referenceables")
            inspectNestedJ2EEResourceProperties(deployedId, resourceEnvProviderId, "propertySet", "customProperties")
            inspectedItem(deployedId)
    except:
        print "Unable to discover ResourceEnvironmentProvider on container:%s" % (container.containmentPath)

def inspectNestedResourceproperties(deployedId, resourceEnvProviderId, nestedProperty):
    for referenceableId in wsadminToList(AdminConfig.showAttribute(resourceEnvProviderId, nestedProperty)):
        inspectedProperty(deployedId, nestedProperty, [AdminConfig.showAttribute(referenceableId, 'factoryClassname') + ':' + AdminConfig.showAttribute(referenceableId, 'classname')])

for c in findAllContainers(container):
    discoverAndInspectResourceEnvProvider(c)
