/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.validator;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="enumValue")
@ApplicableTo(value={PropertyKind.ENUM})
@Target(value={ElementType.FIELD})
public @interface EnumValue {
    public static final String DEFAULT_MESSAGE = "Value '%s' is not one of the allowed values.";

    public String allowedValues() default "";

    public String message() default "Value '%s' is not one of the allowed values.";

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<Object> {
        private String message = "Value '%s' is not one of the allowed values.";
        String allowedValues;

        public void validate(Object value, ValidationContext context) {
            boolean isEnum = false;
            boolean allowedValue = false;
            if (value instanceof Enum) {
                isEnum = true;
                Iterable allowed = Splitter.on((char)',').split((CharSequence)this.allowedValues);
                allowedValue = Iterables.contains((Iterable)allowed, (Object)value.toString());
            }
            if (!isEnum || !allowedValue) {
                context.error(this.message, new Object[]{value});
            }
        }
    }
}

