def findSibQueueDestination(queueName):
    sibuses = AdminTask.listSIBuses()
    if sibuses == "":
        return

    for sibus in sibuses.splitlines():
        busName = AdminConfig.showAttribute(sibus, 'name')
        queues = AdminTask.listSIBDestinations(['-bus', busName, '-type', 'Queue'])
        if queues != "":
            for q in queues.splitlines():
                qName = AdminConfig.showAttribute(q, 'identifier')
                if qName == queueName:
                    return q

    return None

def getSibQueueDestinationId(queue):
    qName = AdminConfig.showAttribute(queue, 'identifier')
    locPrs = wsadminToList(AdminConfig.showAttribute(queue, 'localizationPointRefs'))
    if len(locPrs) != 1:
        print >>sys.stderr, "Was expecting 1 localizationPointRef, but got", locPrsStr
        return
    cluster = AdminConfig.showAttribute(locPrs[0], 'cluster')
    if cluster != None:
        qId = '%s/%s/%s' % (container.id, cluster, qName)
    else:
        if container.wasConfigIdType == 'Cell':
            # WAS ND
            server = AdminConfig.showAttribute(locPrs[0], 'server')
            node = AdminConfig.showAttribute(locPrs[0], 'node')
            if server != None and node != None:
                qId = '%s/%s/%s/%s' % (container.id, node, server, qName)
            else:
                print >>sys.stderr, 'Cannot determine bus member for queue destination %s on SI bus %s' % (qName, busName)
        else:
            # WAS SA
            qId = '%s/%s' % (container.id, qName)

    return qId
