def discoverAndInspectMailProvidersInContainer(container):
    providerContainmentPath = '%s/MailProvider:/' % (container.containmentPath)
    providers = validateNotEmpty(wsadminToList(AdminConfig.getid(providerContainmentPath)), "Cannot locate Mail Provider containment path '%s'" % (providerContainmentPath))
    for mailProvider in providers:
        # DEPL-5821: do not ignore 'Built-in Mail Provider('
        deployedName = AdminConfig.showAttribute(mailProvider, 'name')
        if appendTypeToName:
            deployedId = container.id + '/' + deployedName + '_' + prototype.type
        else:
            deployedId = container.id + '/' + deployedName
        discovered(deployedId, prototype.type)
        inspectedProperty(deployedId, 'wasName', deployedName)
        inspectDeployedProperties(deployedId, deployedName, mailProvider, prototype)
        if getVersion(container) != 'WAS_61':
            cp = AdminConfig.showAttribute(mailProvider, 'classpath')
            if cp == '[]':
                cp = ""
            inspectedProperty(deployedId, 'classpath', cp)
            inspectedProperty(deployedId, 'isolatedClassLoader', AdminConfig.showAttribute(mailProvider, 'isolatedClassLoader'))
        inspectNestedJ2EEResourceProperties(deployedId, mailProvider, "propertySet", "customProperties")
        inspectedItem(deployedId)

for c in findAllContainers(container):
    discoverAndInspectMailProvidersInContainer(c)
