
def jdbcProviderArgs(deployed, ignoreProperty = None):
    exposedProperties = deployed.getExposedProperties(True)
    if getVersion(deployed.container) == 'WAS_61' and 'isolatedClassLoader' in exposedProperties.keys():
        print "Ignoring property 'isolatedClassLoader' which is not supported on WAS 6.1"
        del exposedProperties['isolatedClassLoader']
    if ignoreProperty is not None:
         del exposedProperties[ignoreProperty]
    return toAdminConfigArgs(exposedProperties)

def getJdbcProviderIds(deployed):
    """ return JDBC Provider IDs with deployed.name in deployed.container """
    containerId = AdminConfig.getid(deployed.container.containmentPath)
    jdbcProviders = wsadminToList(AdminConfig.list('JDBCProvider', containerId))
    return [p for p in jdbcProviders if AdminConfig.showAttribute(p, 'name') == deployed.name]

def createJdbcProvider(deployed):
    containerId = AdminConfig.getid(deployed.container.containmentPath)
    args = jdbcProviderArgs(deployed)
    print "Creating JDBC Provider '%s' with arguments %s in the container %s" % (deployed.name, args, deployed.container.name)
    adminConfigCreate('JDBCProvider', containerId, args)

def modifyJdbcProvider(jdbcProviderId, deployed):
    args = jdbcProviderArgs(deployed, 'providerType')
    print "Modifying JDBC Provider '%s' with args '%s' in the container '%s'" % (deployed.name, args, deployed.container.name)
    adminConfigModify(jdbcProviderId, args)
