def modifyDynamicSSLConfigSelection(name, sslConfig, container, connectionInfo):
    ids = validateNotEmpty(getManagementScopeIdAndSSLConfigId(sslConfig, container),
                                       "Cannot locate scope in SSL Config '%s'" % (sslConfig))
    scopeId = ids[0]
    configId = ids[1]
    selectionId = validateNotEmpty(getDynamicSSLConfigSelection(name),
                                   "Cannot locate Dynamic SSL Config Selection '%s'" % (name))
    args = [['name', name], ['description', name]]
    args.append(['managementScope', scopeId])
    args.append(['sslConfig', configId])
    infoListString = "|".join(connectionInfo)
    args.append(['dynamicSelectionInfo', infoListString])
    print "Modifying dynamic ssl config selection '%s' with arguments: %s" % (name, args)
    adminConfigModify(selectionId, args)

def getDynamicSSLConfigSelection(name):
    selectionList = wsadminToList(AdminConfig.list('DynamicSSLConfigSelection'))
    idList = [selection for selection in selectionList if AdminConfig.showAttribute(selection, 'name') == name]
    if idList:
        return idList[0]
    return None

def getManagementScopeIdAndSSLConfigId(sslConfig, container):
    securityId = validateNotEmpty(AdminConfig.getid("/Cell:%s/Security:/" % container.cellName),
                                  "Cannot locate Security object in container '%s'" % (container.name))
    sslConfigList = wsadminToList(AdminConfig.list('SSLConfig', securityId))
    scopeId = ""
    configId = ""
    for sslConfigId in sslConfigList:
        configAlias = AdminConfig.showAttribute(sslConfigId, 'alias')
        if configAlias == sslConfig:
            scopeId = AdminConfig.showAttribute(sslConfigId, 'managementScope')
            configId = sslConfigId
            break
    return [scopeId, configId]

try:
    selection = container

except NameError:
    selection = deployed

modifyDynamicSSLConfigSelection(selection.name, selection.sslConfiguration, selection.container, selection.connectionInformation)

saveConfiguration()
