def deleteDynamicSSLConfigSelection(name, sslConfig, container):
    managementScope = validateNotEmpty(getManagementScope(sslConfig, container),
                                       "Cannot locate scope in SSL Config '%s'" % (sslConfig))
    args = ['-dynSSLConfigSelectionName', name, '-scopeName', managementScope]
    print "Destroying dynamic ssl config selection '%s' with arguments: %s" % (name, listToAdminTaskArgs(args))
    AdminTask.deleteDynamicSSLConfigSelection(listToAdminTaskArgs(args))

def getManagementScope(sslConfig, container):
    securityId = validateNotEmpty(AdminConfig.getid("/Cell:%s/Security:/" % container.cellName),
                                  "Cannot locate Security object in container '%s'" % (container.name))
    sslConfigList = wsadminToList(AdminConfig.list('SSLConfig', securityId))
    scope = ""
    for sslConfigId in sslConfigList:
        configAlias = AdminConfig.showAttribute(sslConfigId, 'alias')
        if configAlias == sslConfig:
            scopeId = AdminConfig.showAttribute(sslConfigId, 'managementScope')
            scope = AdminConfig.showAttribute(scopeId, 'scopeName')
            break
    return scope

def checkIfSelectionExists(name):
    id = AdminConfig.getid('/DynamicSSLConfigSelection:%s/' % (name))
    if id == "":
        print "WARN: Dynamic SSL Config Selection '%s' does not exist. Doing nothing." % name
        sys.exit(0)

try:
    selection = container

except NameError:
    selection = deployed


checkIfSelectionExists(selection.name)
deleteDynamicSSLConfigSelection(selection.name, selection.sslConfiguration, selection.container)

saveConfiguration()

