

/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.container;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.python.DerivedProperty;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.deployable.ManagedServerSpec;
import com.xebialabs.deployit.plugin.was.deployable.ManagedWebServerSpec;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedContainer;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.was.step.ManagedWebServerPluginConfigurationCopyStep;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import static com.google.common.collect.Lists.newArrayList;

import static com.google.common.base.Preconditions.checkNotNull;
import static java.lang.String.format;
import static java.util.Collections.singletonList;

@SuppressWarnings("serial")
@Metadata(description = "A WebSphere Web server managed by a node that is part of a deployment manager (WAS ND)")
public class ManagedWebServer extends ExtensibleDeployedContainer<ManagedWebServerSpec, Node> implements Webserver {

    @Property(required = true, defaultValue = "IHS", description = "Specifies the name of the template that you want to use. Templates include the following: IHS, iPlanet, IIS, DOMINO, APACHE. The default template is IHS.")
    private WebserverType webserverType;

    @DerivedProperty("node")
    public Node getNode() {
        return getContainer();
    }

    public void setNode(NodeAgent node) {
        setContainer(node);
    }

    @Override
    public Cell getCell() {
        checkNotNull(getNode(), "%s has null node", this);

        return getNode().getCell();
    }

    @Override
    public PythonManagingContainer getManagingContainer() {
        return getCell();
    }

    @Override
    public String getCellName() {
        checkNotNull(getCell(), "%s has null cell", this);

        return getCell().getName();
    }

    @DerivedProperty("nodeName")
    public String getNodeName() {
        checkNotNull(getNode(), "%s has null node", this);

        return getNode().getName();
    }

    @Override
    public Set<Node> getNodes() {
        return Collections.singleton((Node) this.getNode());
    }

    @Override
    public WebserverType getWebserverType() {
        return webserverType;
    }

    @Override
    public void setWebserverType(WebserverType webserverType) {
        this.webserverType = webserverType;
    }

    @Override
    public String getContainmentPath() {
        return "/Node:" + getNodeName() + "/Server:" + getName();
    }


    @Override
    public String getWasConfigIdType() {
        return "Server";
    }

    @Override
    public String getWasTargetType() {
        return "server";
    }

    @Override
    public String getShortTypeDescription() {
        return "managed webserver";
    }

    @Override
    public Host getHost() {
        return getNode().getHost();
    }

    public List<Step> controlTaskDispatch(String name, Map<String, String> args) {
        return ControlTaskDelegate.dispatch(name, args, this, this);
    }

    @ControlTask(label="Propagate Plugin", description="Distributes the webserver plugin.")
    public List<Step> propagatePlugin() {
        Integer propagatePluginOrder = this.getProperty("propagatePluginOrder");
        if(this.<Host>getProperty("host") != null) {
            Step prop =  new ManagedWebServerPluginConfigurationCopyStep(propagatePluginOrder, this);
            List<Step> stepsList = newArrayList(prop);
            return stepsList;
        } else {
            Step prop = new PythonDeploymentStep(propagatePluginOrder, this.getNode().getCell(),
                    this.<String>getProperty("propagatePluginScript"),
                    ImmutableMap.<String, Object>of("container", this),
                    format("Propagate web server plugin configuration to web server '%s'", this.getName()));
            List<Step> stepsList = newArrayList(prop);
            return stepsList;
        }
    }

    @Override
    public List<String> getApplicationManagerObjectNames() {
        checkNotNull(getNode(), "%s has null node", this);
        checkNotNull(getCell(), "%s has null cell", this);

        String applicationManagerObjectName = "cell=" + getCellName() + ",node=" + getNodeName() + ",type=ApplicationManager,process=" + getName() + ",*";
        return singletonList(applicationManagerObjectName);
    }
}
