import sys

def getServerConfig(server):
    return [[server.port, server.installPath, server.pluginInstallPath, server.configPath,
             server.serviceName, server.errorLogfile, server.accessLogfile, server.webProtocol]]

def getRemoteServerConfig(server):
    return [[server.adminPort, server.adminProtocol, server.adminUserID, server.adminPasswd]]

def createServer(server):
    nodeName = server.nodeName
    serverName = server.name
    serverType = server.webserverType
    serverConfig = getServerConfig(server)
    remoteServerConfig = None
    if server.adminPort is not '':
        remoteServerConfig = getRemoteServerConfig(server)
    args = ['-name', serverName, '-serverConfig', serverConfig, '-templateName', serverType]
    if remoteServerConfig is not None:
      args.append('-remoteServerConfig')
      args.append(remoteServerConfig)
    print "Creating server '%s' on node '%s': %s" % (serverName, nodeName, args)
    AdminTask.createWebServer(nodeName, args)



def checkIfServerExists(server):
    nodeName = server.nodeName
    serverName = server.name
    serverId = AdminConfig.getid('/Node:%s/Server:%s/' % (nodeName, serverName))
    if serverId != "":
        print "WARN: Server '%s' already exists on node '%s'. Doing nothing." % (serverName, nodeName)
        sys.exit(0)

try:
    server = container

except NameError:
    server = deployed

checkIfServerExists(server)
createServer(server)

saveConfiguration()
syncNode(server.nodeName)

