package com.xebialabs.deployit.plugin.was.validator;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;

@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = EnumValue.Validator.class, type = "enumValue")
@ApplicableTo({ PropertyKind.ENUM })
@Target(ElementType.FIELD)
public @interface EnumValue {
    String DEFAULT_MESSAGE = "Value '%s' is not one of the allowed values.";
    String allowedValues() default "";
    String message() default DEFAULT_MESSAGE;

    public static class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<Object> {
        private String message = DEFAULT_MESSAGE;
        String allowedValues;

        @Override
        @SuppressWarnings({ "unchecked" })
        public void validate(Object value, ValidationContext context) {
            boolean isEnum = false;
            boolean allowedValue = false;
            if (value instanceof Enum) {
                isEnum = true;
                Iterable<String> allowed = Splitter.on(',').split(allowedValues);
                allowedValue = Iterables.contains(allowed, value.toString());
            }

            if (!isEnum || !allowedValue) {
                context.error(message, value);
            }
        }

    }
}