#
from com.ibm.ws.scripting import ScriptingException

################################################################################################################
# WMQ utility functions
################################################################################################################
def wsadminTaskToDict(inStr):
    map = {}
    key = ""
    if (len(inStr)>0 and inStr[0]== '{' and inStr[-1]== '}'):
        inStr = inStr[1:-1]
    tmpList = inStr.split(",")
    for p in tmpList:
        pNameValue = p.strip().split("=")
        if len(pNameValue) == 2:
            map[pNameValue[0]] = pNameValue[1]
            key = pNameValue[0]
        else:
            map[key] = map[key] + ", " + pNameValue[0]

    return map

def findWmqActivationSpec(deployed):
    container = deployed.container
    containerId = AdminConfig.getid(container.containmentPath)
    for wmqActivationSpecId in wsadminToList(AdminTask.listWMQActivationSpecs(containerId)):
        if wmqActivationSpecId[:wmqActivationSpecId.find("(")] == deployed.name:
            return wmqActivationSpecId
    printErrorAndExit("ERROR: Unable to find WmqActivationSpecification '%s' in container '%s'" % (deployed.name, container.name))

def wmqActivationSpecProps(deployed):
    props = deployed.getExposedProperties(True)
    return props

################################################################################################################
# WMQ create, modify, destroy, discover functions
################################################################################################################
def createWmqActivationSpec(props, deployed):
    if props.get("ccdtUrl", None) or props.get("ccdtQmgrName", None):
        exclude_props = ["qmgrName", "qmgrHostname", "qmgrPortNumber", "qmgrSvrconnChannel", "localAddress", "wmqTransportType", "connectionNameList"]
        print "Ignoring properties not valid in combination with 'ccdtUrl' and 'ccdtQmgrName' - %s" % exclude_props
        for exclude_prop in exclude_props:
            del props[exclude_prop]

    if props.get("wmqTransportType") == "BINDINGS":
        exclude_props = ["qmgrHostname", "qmgrPortNumber", "qmgrSvrconnChannel", "localAddress", "connectionNameList", "sslType", "sslConfiguration"]
        print "Ignoring properties not valid in combination with 'BINDINGS' transport type - %s" % exclude_props
        for exclude_prop in exclude_props:
            del props[exclude_prop]

    args = toAdminTaskArgs(props)
    containerId = validateNotEmpty(AdminConfig.getid(deployed.container.containmentPath), "Cannot find target container '%s'" % deployed.container.name)
    print "Creating WmqActivationSpecification '%s' in container '%s' with args '%s'" % (deployed.name, deployed.container.name, args)
    activationSpecId = AdminTask.createWMQActivationSpec(containerId, args)
    if hasattr(deployed, "customProperties"):
        createOrUpdateCustomProps(activationSpecId, "J2EEResourceProperty", deployed)

def modifyWmqActivationSpec(props, deployed):
    # we are not able to reset custom properties and a few other properties so we destroy and re-create the activation spec
    destroyWmqActivationSpec(deployed)
    createWmqActivationSpec(props, deployed)

def destroyWmqActivationSpec(deployed):
    print "Destroying WmqActivationSpecification '%s' in container '%s'" % (deployed.name, deployed.container.name)
    AdminTask.deleteWMQActivationSpec(findWmqActivationSpec(deployed))

def discoverAndInspectWmqActivationSpecs(container, prototype, appendTypeToName):
    for c in findAllContainers(container):
        containerId = validateNotEmpty(AdminConfig.getid(c.containmentPath), "Cannot find container for path %s" % c.containmentPath)
        print "Retrieving list of %s objects in container %s" % ("WmqActivationSpecification", c.name)
        try:
            for wmqActivationSpecId in wsadminToList(AdminTask.listWMQActivationSpecs(containerId)):
                deployedName = AdminConfig.showAttribute(wmqActivationSpecId, 'name')
                print "Discovered %s %s in container %s" % ("WmqActivationSpecification", deployedName, c.name)
                if appendTypeToName:
                    deployedId = c.id + '/' + deployedName + '_' + prototype.type
                else:
                    deployedId = c.id + '/' + deployedName
                discovered(deployedId, prototype.type)
                inspectedProperty(deployedId, 'wasName', deployedName)
                inspectWmqActivationSpec(deployedId, deployedName, wmqActivationSpecId, c)
                inspectedItem(deployedId)
        except ScriptingException, e:
            print "WARN: Unable to list %s objects in container %s (Exception: %s). Ignoring..." % ("WmqActivationSpecification", c.name, e.message)

def inspectWmqActivationSpec(deployedId, deployedName, jmsId, container,
                             propRenames = {"messageRetention": "msgRetention",
                                            "authenticationAlias": "authAlias",
                                            "useJNDI": None,
                                            "clientID": "clientId",
                                            "acknowledgeMode": None}):

    exposedProperties = prototype.getExposedPropertyNames()
    customProperties = {}
    properties = wsadminTaskToDict(AdminTask.showWMQActivationSpec(jmsId))

    for pName in properties.keys():
        pValue = properties.get(pName)
        pName = propRenames.get(pName, pName)
        if not pName:
            continue

        if pValue and pName == 'connectionNameList':
            pValue = pValue.replace(", ", ",")

        if pName in exposedProperties:
            if pValue is not None and pValue != "null":
                inspectedProperty(deployedId, pName, pValue)
        else:
            customProperties[pName] = pValue

    if len(customProperties) > 0:
        inspectedProperty(deployedId, "customProperties", customProperties)

