
def getServletCacheInstanceId(container, servletCacheInstanceName):
    servletCacheInstanceId = AdminConfig.getid('%s/CacheProvider:CacheProvider/ServletCacheInstance:%s' % (container.containmentPath, servletCacheInstanceName))
    if servletCacheInstanceId:
        return servletCacheInstanceId
    return None

def configureEvictionPolicy(container, servletCacheInstanceId, servletCacheInstanceName, servletCacheInstanceProperty, cachePropertyToCreate, deplyedCacheExposedProperty):
    evictionPolicyId = AdminConfig.showAttribute(servletCacheInstanceId, servletCacheInstanceProperty)
    evictionPolicyArgs = toAdminConfigArgs(deplyedCacheExposedProperty)
    if evictionPolicyId is None:
        print "Creating Eviction Policy for Servlet Cache Instance '%s' in container '%s'" % (servletCacheInstanceName, container.name)
        evictionPolicyId = adminConfigCreate(cachePropertyToCreate, servletCacheInstanceId, '[]')
    if (deployed.enableDiskOffload) and (cachePropertyToCreate == 'DiskCacheEvictionPolicy'):
        print "Modifying Eviction Policy for Servlet Cache Instance '%s' in container '%s' with args '%s'" % (servletCacheInstanceName, container.name, evictionPolicyArgs)
        adminConfigModify(evictionPolicyId, evictionPolicyArgs)
    else:
        print "Modifying Eviction Policy for Servlet Cache Instance '%s' in container '%s' with args '%s'" % (servletCacheInstanceName, container.name, evictionPolicyArgs)
        adminConfigModify(evictionPolicyId, evictionPolicyArgs)

def configurePerformanceSettings(container, servletCacheInstanceId, servletCacheInstanceName):
    diskCacheCustomPerformanceSettingsId = AdminConfig.showAttribute(servletCacheInstanceId, 'diskCacheCustomPerformanceSettings')
    if diskCacheCustomPerformanceSettingsId is None:
        print "Creating Performance Settings for Servlet Cache Instance '%s' in container '%s'" % (servletCacheInstanceName, container.name)
        diskCacheCustomPerformanceSettingsId = adminConfigCreate('DiskCacheCustomPerformanceSettings', servletCacheInstanceId, '[]')
    if (deployed.diskCachePerformanceLevel) == 'CUSTOM':
        performanceArgs = [['maxBufferedDependencyIds', deployed.maxBufferedDependencyIds], ['maxBufferedCacheIdsPerMetaEntry', deployed.maxBufferedCacheIdsPerMetaEntry], ['maxBufferedTemplates', deployed.maxBufferedTemplates]]
        print "Modifying Disk Cache Custom Performance Settings for Servlet Cache Instance '%s' in container '%s' with args '%s'" % (servletCacheInstanceName, container.name, performanceArgs)
        adminConfigModify(diskCacheCustomPerformanceSettingsId, performanceArgs)

def getServletCacheInstanceArgs(deployed):
    args = toAdminConfigArgs(deployed.getExposedProperties(True))
    if deployed.enableDiskOffload:
        diskCacheArgs = (['diskCacheCleanupFrequency', deployed.diskCacheCleanupFrequency], ['diskCachePerformanceLevel', deployed.diskCachePerformanceLevel], ['diskCacheEntrySizeInMB', deployed.diskCacheEntrySizeInMB], ['diskCacheSizeInEntries', deployed.diskCacheSizeInEntries], ['diskCacheSizeInGB', deployed.diskCacheSizeInGB], ['diskOffloadLocation', deployed.diskOffloadLocation])
        if deployed.flushToDiskOnStop:
            args.extend([['flushToDiskOnStop', 'true']])
        else:
            args.extend([['flushToDiskOnStop', 'false']])
        args.extend(diskCacheArgs)
        if getVersion(deployed.container) != 'WAS_61':
            args.extend([['memoryCacheSizeInMB', deployed.memoryCacheSizeInMB]])
    return args