import sys
from javax.management import ObjectName
from java.util import Properties

dynCluster = AdminConfig.getid('/DynamicCluster:%s/' % (container.name))
if dynCluster != "":
    raise "Dynamic cluster '%s' already exists." % (container.name)

if container.cell.version == 'WAS_61':
    raise "Dynamic ODR clusters are not supported on WAS 6.1"

if container.cell.version == 'WAS_85':
    if not hasattr(container, 'nodeGroupName') or container.nodeGroupName is None:
        raise "Property 'nodeGroupName' is required for WAS 8.5"

    dynamicClusterManager = AdminControl.queryNames("WebSphere:*,process=dmgr,type=DynamicClusterConfigManager")
    if dynamicClusterManager is None:
        raise "Unable to locate DynamicClusterConfigManager MBean"

    dynamicClusterProps = Properties()
    dynamicClusterProps.put("operationalMode", container.operationalMode.lower())
    if hasattr(container, 'minInstances') and container.minInstances is not None:
        dynamicClusterProps.put("minInstances", str(container.minInstances))
    if hasattr(container, 'maxInstances') and container.maxInstances is not None:
        dynamicClusterProps.put("maxInstances", str(container.maxInstances))
    if hasattr(container, 'numVerticalInstances') and container.numVerticalInstances is not None:
        dynamicClusterProps.put("numVerticalInstances", str(container.numVerticalInstances))

    clusterProps = Properties()
    if hasattr(container, 'memberTemplateName') and container.memberTemplateName is not None:
        clusterProps.put("templateName", container.memberTemplateName)

    print "Creating dynamic ODR cluster '%s' using %s%s" % (container.name, dynamicClusterProps, clusterProps)
    AdminControl.invoke_jmx(ObjectName(dynamicClusterManager), "createODRDynamicCluster", [container.nodeGroupName, container.name, dynamicClusterProps, clusterProps], ["java.lang.String", "java.lang.String", "java.util.Properties", "java.util.Properties"])
    # cannot be set using the JMX call
    clusterId = validateNotEmpty(AdminConfig.getid("/DynamicCluster:%s/" % (container.name)), "Cannot locate dynamic ODR cluster '%s'" % (container.name));
    adminConfigModify(clusterId, [['membershipPolicy', container.membershipPolicy]])

else:
    args = "[%s]" %(dynamicClusterArgs(container))
    print "Creating dynamic ODR cluster '%s' using %s" % (container.name, args)
    AdminTask.createODRDynamicCluster(container.name, args)

print "Saving configuration"
AdminConfig.save()
syncNodes(container.cell)