/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.validator;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Rule(clazz=Validator.class, type="was-long-range")
@ApplicableTo(value={PropertyKind.STRING})
public @interface LongRange {
    public static final String RANGE_ERROR_MESSAGE = "Value %s is not in range [%s, %s]";
    public static final String FORMAT_ERROR_MESSAGE = "Value %s is not a valid number";
    public static final String MINMAX_ERROR_MESSAGE = "Invalid minimum or maximum value minimum is %s, maximum is %s";
    public static final String MIN_VALUE = "-9223372036854775808";
    public static final String MAX_VALUE = "9223372036854775807";

    public String minimum() default "-9223372036854775808";

    public String maximum() default "9223372036854775807";

    public String rangeErrorMessage() default "Value %s is not in range [%s, %s]";

    public String formatErrorMessage() default "Value %s is not a valid number";

    public String minMaxErrorMessage() default "Invalid minimum or maximum value minimum is %s, maximum is %s";

    public static class Validator
    implements com.xebialabs.deployit.plugin.api.validation.Validator<String> {
        private String minimum = "-9223372036854775808";
        private String maximum = "9223372036854775807";
        private String rangeErrorMessage = "Value %s is not in range [%s, %s]";
        private String formatErrorMessage = "Value %s is not a valid number";
        private String minMaxErrorMessage = "Invalid minimum or maximum value minimum is %s, maximum is %s";

        public void validate(String value, ValidationContext context) {
            if (value == null) {
                return;
            }
            try {
                long min = Long.parseLong(this.minimum);
                long max = Long.parseLong(this.maximum);
                try {
                    long longValue = Long.parseLong(value);
                    if (longValue < min || longValue > max) {
                        context.error(this.rangeErrorMessage, new Object[]{value, this.minimum, this.maximum});
                    }
                }
                catch (NumberFormatException e) {
                    context.error(this.formatErrorMessage, new Object[]{value});
                }
            }
            catch (NumberFormatException e) {
                context.error(this.minMaxErrorMessage, new Object[]{this.minimum, this.maximum});
            }
        }
    }
}

