package com.xebialabs.deployit.plugin.was.controltask.dmgr;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.was.container.DeploymentManager;
import com.xebialabs.deployit.plugin.was.container.NodeAgent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SuppressWarnings("serial")
public class DeploymentManagerDelegate implements Serializable {
    private static final String KEY_DEPLOYMENT_MANAGER = "deploymentManager";
    private static final String PROPERTY_TARGET = "target";

    @Delegate(name="dmgrRestart")
    public static List<Step> restartDmgr(ConfigurationItem dmgr, String method, Map<String, String> arguments, Parameters params) {
        ArrayList<Step> restartSteps = Lists.newArrayList();
        DeploymentManagerDelegateTarget target = params.getProperty(PROPERTY_TARGET);
        restartSteps.addAll(createDmgrSteps((DeploymentManager) dmgr, Operation.STOP, target));
        restartSteps.addAll(createDmgrSteps((DeploymentManager) dmgr, Operation.START, target));
        return restartSteps;
    }

    @Delegate(name="dmgrStart")
    public static List<Step> startDmgr(ConfigurationItem dmgr, String method, Map<String, String> arguments, Parameters params) {
        DeploymentManagerDelegateTarget target = params.getProperty(PROPERTY_TARGET);
        return createDmgrSteps((DeploymentManager) dmgr, Operation.START, target);
    }

    @Delegate(name="dmgrStop")
    public static List<Step> stopDmgr(ConfigurationItem dmgr, String method, Map<String, String> arguments, Parameters params) {
        DeploymentManagerDelegateTarget target = params.getProperty(PROPERTY_TARGET);
        return createDmgrSteps((DeploymentManager) dmgr, Operation.STOP, target);
    }

    private static List<Step> createDmgrSteps(DeploymentManager dmgr, Operation operation, DeploymentManagerDelegateTarget target) {
        Set<NodeAgent> nodeAgents = Sets.newLinkedHashSet(Iterables.filter(dmgr.getNodes(), NodeAgent.class));
        List<Step> steps = Lists.newArrayList();
        switch (target) {
        case DEPLOYMENT_MANAGER_AND_NODE_AGENTS:
            steps.add(StartStopDelegate.createStep(operation, dmgr, getContext(dmgr)));
            steps.addAll(nodeAgentSteps(operation, nodeAgents));
            break;
        case DEPLOYMENT_MANAGER:
            steps.add(StartStopDelegate.createStep(operation, dmgr, getContext(dmgr)));
            break;
        case NODE_AGENTS:
            steps.addAll(nodeAgentSteps(operation, nodeAgents));
            break;
        }

        return steps;
    }

    private static List<Step> nodeAgentSteps(Operation operation, Set<NodeAgent> nodeAgents) {
        List<Step> steps = Lists.newArrayList();
        for (NodeAgent nodeAgent : nodeAgents) {
            steps.add(NodeAgentDelegate.createStep(operation, nodeAgent));
        }
        return steps;
    }

    private static Map<String, Object> getContext(DeploymentManager dmgr) {
        Map<String, Object> ctx = Maps.newHashMap();
        ctx.put(KEY_DEPLOYMENT_MANAGER, dmgr);
        return ctx;
    }

}