package com.xebialabs.deployit.plugin.was.validator;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;

import static com.google.common.base.Splitter.on;
import static com.google.common.collect.Iterables.contains;

@Retention(RetentionPolicy.RUNTIME)
@Rule(clazz = Enumeration.Validator.class, type = "enumeration")
@ApplicableTo({PropertyKind.STRING})
@Target(ElementType.FIELD)
public @interface Enumeration {
    String DEFAULT_MESSAGE = "Value '%s' is not one of the allowed values (%s)";

    String message() default DEFAULT_MESSAGE;

    String values() default "";

    public static class Validator implements com.xebialabs.deployit.plugin.api.validation.Validator<Object> {
        String message = DEFAULT_MESSAGE;
        String values;

        @Override
        public void validate(Object value, ValidationContext context) {
            if (value != null && !"".equals(value)) {
                if (!contains(on(',').omitEmptyStrings().split(values), value.toString())) {
                    context.error(message, value, values);
                }
            }
        }

    }
}