def createDynamicSSLConfigSelection(name, sslConfig, container, connectionInfo):
    managementScope = validateNotEmpty(getManagementScope(sslConfig, container),
                                       "Cannot locate scope in SSL Config '%s'" % (sslConfig))
    args = ['-dynSSLConfigSelectionName', name, '-dynSSLConfigSelectionDescription', name]
    args.extend(['-scopeName', managementScope])
    args.extend(['-sslConfigName', sslConfig])
    infoListString = "|".join(connectionInfo)
    args.extend(['-dynSSLConfigSelectionInfo', infoListString])
    print "Creating dynamic ssl config selection '%s' with arguments: %s" % (name, listToAdminTaskArgs(args))
    AdminTask.createDynamicSSLConfigSelection(listToAdminTaskArgs(args))

def getManagementScope(sslConfig, container):
    securityId = validateNotEmpty(AdminConfig.getid("/Cell:%s/Security:/" % container.cellName),
                                  "Cannot locate Security object in container '%s'" % (container.name))
    sslConfigList = wsadminToList(AdminConfig.list('SSLConfig', securityId))
    scope = ""
    for sslConfigId in sslConfigList:
        configAlias = AdminConfig.showAttribute(sslConfigId, 'alias')
        if configAlias == sslConfig:
            scopeId = AdminConfig.showAttribute(sslConfigId, 'managementScope')
            scope = AdminConfig.showAttribute(scopeId, 'scopeName')
            break
    return scope

try:
    selection = container

except NameError:
    selection = deployed

createDynamicSSLConfigSelection(selection.name, selection.sslConfiguration, selection.container, selection.connectionInformation)

saveConfiguration()
