
def discoverHealthConditionNestedObjects(deployedId, id):
    attributes = AdminConfig.show(id)
    attrMap = wsadminToDict(attributes)
    for key in attrMap.keys():
        if key in ageUnitsList:
            inspectedProperty(deployedId, key, wasToAgeUnitsMap[attrMap[key]])
        elif key in numberToUnitsList:
            inspectedProperty(deployedId, key, wasToTimeUnitsMap[attrMap[key]])
        elif key != 'name':
            inspectedProperty(deployedId, key, attrMap[key])

def inspectHealthCondition(healthPolicyId, healthPolicy):
    condition = AdminConfig.showAttribute(healthPolicy, 'HealthCondition')
    conditionType = AdminConfig.getObjectType(condition)

    print "Inspecting health policy condition '%s' type '%s'" % (condition, conditionType)
    name = AdminConfig.showAttribute(condition, 'name')
    conditionId = "%s/%s" % (healthPolicyId, name)
    if appendTypeToName:
        conditionId = conditionId + '_' +  wasToConditionTypeMap[conditionType]
    discovered(conditionId, wasToConditionTypeMap[conditionType])
    inspectedProperty(conditionId, 'wasName', name)

    if conditionType == 'AgeCondition':
        discoverHealthConditionNestedObjects(conditionId, condition)
    elif conditionType == 'StormDrainCondition':
        inspectedProperty(conditionId, 'level', AdminConfig.showAttribute(condition, 'level'))
    elif conditionType == 'MemoryCondition':
        discoverHealthConditionNestedObjects(conditionId, condition)
    elif conditionType == 'WorkloadCondition':
        inspectedProperty(conditionId, 'totalRequests', AdminConfig.showAttribute(condition, 'totalRequests'))
    elif conditionType == 'StuckRequestCondition':
        inspectedProperty(conditionId, 'timeoutPercent', AdminConfig.showAttribute(condition, 'timeoutPercent'))
    elif conditionType == 'MemoryLeakAlgorithm':
        inspectedProperty(conditionId, 'level', AdminConfig.showAttribute(condition, 'level'))
    elif conditionType == 'ResponseCondition':
        discoverHealthConditionNestedObjects(conditionId, condition)
    elif conditionType == 'GCPercentageCondition':
        discoverHealthConditionNestedObjects(conditionId, condition)
    else:
        print "WARN: unhandled conditionType '%s' on '%s'" % (conditionType, healthPolicyId)

    inspectedItem(conditionId)


def inspectHealthActions(healthPolicyId, healthPolicyName, healthPolicy):
    actionMap = findHealthActions(healthPolicy)
    steps = list(actionMap.keys())
    steps.sort()
    for stepNum in steps:
        actionId = healthPolicyId + '/' + stepNum
        if appendTypeToName:
            actionId = actionId + '_' + actionTypeMap[actionMap[stepNum]]

        discovered(actionId, actionTypeMap[actionMap[stepNum]])
        inspectedProperty(actionId, 'wasName', stepNum)
        inspectedItem(actionId)

print "Inspecting container: '%s'" % container.name
healthPoliciesList = wsadminToList(AdminTask.listHealthPolicies())

for healthPolicy in healthPoliciesList:
    healthPolicyName = AdminConfig.showAttribute(healthPolicy, 'name')
    print "Inspecting health policy '%s' of type '%s'" % (healthPolicyName, prototype.type)

    if appendTypeToName:
        healthPolicyId = container.id + '/' + healthPolicyName + '_' + prototype.type
    else:
        healthPolicyId = container.id + '/' + healthPolicyName
    discovered(healthPolicyId, prototype.type)
    inspectedProperty(healthPolicyId, 'wasName', healthPolicyName)
    inspectedProperty(healthPolicyId, 'description', AdminConfig.showAttribute(healthPolicy, 'description'))
    inspectedProperty(healthPolicyId, 'reactionMode', wasToReactionModeMap[AdminConfig.showAttribute(healthPolicy, 'reactionMode')])

    inspectHealthCondition(healthPolicyId, healthPolicy)
    inspectHealthActions(healthPolicyId, healthPolicyName, healthPolicy)

    inspectedItem(healthPolicyId)
