import time
import os

from  com.ibm.ws.scripting import ScriptingException
#
# util
#
def getCompleteName(serverName):
    return AdminControl.completeObjectName('WebSphere:type=Server,name=' + serverName + ',*')

def getServerStatus(serverName):
    try:
        completeName = getCompleteName(serverName)
        serverStatus = AdminControl.getAttribute(completeName, 'state')
        return serverStatus
    except:
        return 'STOPPED'

def waitUntil(state, failure, serverName, maxRetries, sleepTime, action):
    serverStatus = getServerStatus(serverName)
    retry = 0
    while retry < maxRetries and not serverStatus == state:
        retry = retry + 1
        print "Attempt %s on %s. Server %s." % (action, retry, serverName)
        time.sleep(sleepTime)
        serverStatus = getServerStatus(serverName)

    serverStatus = getServerStatus(serverName)
    if not serverStatus == state: raise failure
    return 1;
#
# start
#

def startServer(serverName, operatingSystem, path):
    sleepTime = 5
    maxRetries = 20
    serverStatus = getServerStatus(serverName)

    if 'STARTED' == serverStatus:
        print "INFO: Server %s is already started. Nothing to do." % (serverName)
    else:
        executeStartServerCommand(serverName, operatingSystem, path)
        isStarted = waitUntil('STARTED', 'ERROR: Server not started in %s seconds.' % (maxRetries * sleepTime), serverName, maxRetries, sleepTime, 'Start')
        if isStarted == 1: print "SUCCESS: Server %s is started." % (serverName)

def executeStartServerCommand(serverName, operatingSystem, path):
    path = os.path.join(path, 'bin', '.', 'startServer')
    extension = ('sh', 'bat')[operatingSystem == 'WINDOWS']
    command = '%s.%s %s' % (path, extension, serverName)
    return os.system(command)

#
# stop
#
def stopImmediate(serverName, maxRetries, sleepTime):
        try:
            serverStatus = getServerStatus(serverName)
            if 'STARTED' == serverStatus:
                AdminControl.stopServer(serverName, 'immediate')
                isStopped = waitUntil('STOPPED', 'Server did not stop in %s seconds.' % (maxRetries * sleepTime), serverName, maxRetries, sleepTime, 'Stop')
                if isStopped == 1: print "SUCCESS: Server %s is stopped." % (serverName)
        except:
            serverStatus = getServerStatus(serverName)
            if 'STOPPED' == serverStatus: return
            raise "Server %s did not stop in stipulated time. Current status: %s." % (serverName, serverStatus)

def stopServer(serverName):
    sleepTime = 5
    maxRetries = 30
    serverStatus = getServerStatus(serverName)
    if 'STOPPED' == serverStatus:
        print "Server %s is already stopped." % (serverName)
    else:
        stopImmediate(serverName, maxRetries, sleepTime)

stopServer(container.name)
time.sleep(40)
startServer(container.name, container.host.os, container.wasHome)
